/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.CorrSet;
import filenet.vw.api.IVWHasWSParameterDefs;
import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWAssociationDefinition;
import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFaultDefinition;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWGuid;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWInvokeInstruction;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWMergeType;
import filenet.vw.api.VWModeType;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWPartnerLinkDefinition;
import filenet.vw.api.VWReceiveInstruction;
import filenet.vw.api.VWReplyInstruction;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWTextAnnotationDefinition;
import filenet.vw.api.VWTimeUnitType;
import filenet.vw.api.VWWebServiceParameterDefinition;
import filenet.vw.api.VWWorkflowCollectionDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.api.VWXMLSchemaSubType;
import filenet.vw.api.VWXML_CUR_parser;
import filenet.vw.base.VWString;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class VWXPDL_20_parser {
    private static String m_namespacePrefix = null;
    private static final int OBJECT_TYPE_MAPNODE = 1;
    private static final int OBJECT_TYPE_ROUTE = 2;
    private static final int OBJECT_TYPE_INSTRUCTION = 3;
    private static final int OBJECT_TYPE_TEXT_ANNOTATION = 4;

    VWXPDL_20_parser() {
    }

    protected static VWWorkflowCollectionDefinition parseXPDLDocument(Element wfele, String namespacePrefix) throws VWException, SAXException {
        VWWorkflowDefinition[] wfdefs;
        int numChilds;
        XPDLInfo xpdlInfo = new XPDLInfo();
        xpdlInfo.packageDataFields = null;
        xpdlInfo.partnerLinkTypeNodes = null;
        xpdlInfo.idInfo = null;
        m_namespacePrefix = namespacePrefix;
        VWWorkflowCollectionDefinition wfc = new VWWorkflowCollectionDefinition();
        if (wfele.getAttributeNode("Name") != null) {
            wfc.setName(wfele.getAttribute("Name"));
        } else {
            String idStr = wfele.getAttribute("Id");
            boolean isInteger = true;
            try {
                Integer.parseInt(idStr);
            }
            catch (Exception ex) {
                isInteger = false;
            }
            if (!isInteger) {
                wfc.setName(idStr);
            }
        }
        VWXPDL_20_parser.savePackageAttributes(wfele, wfc);
        boolean validXPDL = false;
        Node associationsNode = null;
        Node artifactsNode = null;
        NodeList childNodes = wfele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node aNode = childNodes.item(i);
                String nodeName = aNode.getNodeName();
                if (nodeName.equals(m_namespacePrefix + "PackageHeader")) {
                    validXPDL = VWXPDL_20_parser.parseXPDLPackageHeader(aNode, wfc);
                    continue;
                }
                if (validXPDL && nodeName.equals(m_namespacePrefix + "DataFields")) {
                    xpdlInfo.packageDataFields = aNode;
                    continue;
                }
                if (validXPDL && nodeName.equals(m_namespacePrefix + "PartnerLinkTypes")) {
                    Element partnerLinkTypesElement = (Element)aNode;
                    NodeList pltChildNodes = partnerLinkTypesElement.getChildNodes();
                    if (pltChildNodes == null || pltChildNodes.getLength() == 0) continue;
                    xpdlInfo.partnerLinkTypeNodes = pltChildNodes;
                    continue;
                }
                if (nodeName.equals(m_namespacePrefix + "Pools")) {
                    wfc.setOriginalPoolsNode(aNode);
                    continue;
                }
                if (nodeName.equals(m_namespacePrefix + "Associations")) {
                    associationsNode = aNode;
                    continue;
                }
                if (nodeName.equals(m_namespacePrefix + "Artifacts")) {
                    artifactsNode = aNode;
                    continue;
                }
                if (validXPDL && nodeName.equals(m_namespacePrefix + "WorkflowProcesses")) {
                    VWXPDL_20_parser.parseXPDLWorkflowProcesses(aNode, wfc, xpdlInfo);
                    continue;
                }
                if (!validXPDL || !nodeName.equals("fn:ScenarioDefinitions")) continue;
                wfc.setScenarioDefinitionsNode(aNode);
            }
        }
        if (!validXPDL) {
            throw new VWException("vw.VWXMLHandler.VWInvalidXPDL", "Not a valid XPDL document.");
        }
        if (artifactsNode != null) {
            VWXPDL_20_parser.parseXPDLArtifactsAndAssociations(artifactsNode, associationsNode, wfc, xpdlInfo);
        }
        if ((wfdefs = wfc.getWorkflows()) != null) {
            for (int w = 0; w < wfdefs.length; ++w) {
                VWMapDefinition[] maps = wfdefs[w].getMaps();
                if (maps == null) continue;
                for (int m = 0; m < maps.length; ++m) {
                    VWXPDL_20_parser.setAnnotationLocations(maps[m]);
                    maps[m].updateNextAnnotationId();
                }
            }
        }
        wfc.setSource(2);
        return wfc;
    }

    static void savePackageAttributes(Element wfele, VWWorkflowCollectionDefinition wfc) {
        NamedNodeMap nnm = wfele.getAttributes();
        int attributeCount = nnm.getLength();
        if (attributeCount > 0) {
            String[] attributeArray = new String[attributeCount];
            for (int i = 0; i < attributeCount; ++i) {
                Node attributeNode = nnm.item(i);
                attributeArray[i] = attributeNode.getNodeName() + "=\"" + attributeNode.getNodeValue() + "\"";
            }
            wfc.setPackageAttributes(attributeArray);
        }
    }

    static boolean parseXPDLPackageHeader(Node aNode, VWWorkflowCollectionDefinition wfc) throws VWException {
        NodeList childNodes;
        if (aNode.getNodeType() != 1) {
            return false;
        }
        Element ele = (Element)aNode;
        if (ele.getAttributeNode("fn:AuthorTool") != null) {
            wfc.setAuthorTool(ele.getAttribute("fn:AuthorTool"));
        }
        if (ele.getAttributeNode("fn:ApplicationSpaceName") != null) {
            wfc.setApplicationSpaceName(ele.getAttribute("fn:ApplicationSpaceName"));
        }
        if ((childNodes = ele.getChildNodes()) != null) {
            for (int i = 0; i < childNodes.getLength(); ++i) {
                String desc;
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (nodeName.equals(m_namespacePrefix + "XPDLVersion")) {
                    String version = VWXMLHandler.getXMLString(childNode);
                    if (version == null) continue;
                    wfc.setXpdlSourceVersion(version);
                    continue;
                }
                if (!nodeName.equals(m_namespacePrefix + "Description") || (desc = VWXMLHandler.getXMLString(childNode)) == null || desc.length() <= 0) continue;
                wfc.setDescription(desc);
            }
        }
        return true;
    }

    static void parseXPDLWorkflowProcesses(Node aNode, VWWorkflowCollectionDefinition wfc, XPDLInfo xpdlInfo) throws VWException, SAXException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            xpdlInfo.workflowProcessNodes = childNodes;
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(m_namespacePrefix + "WorkflowProcess")) continue;
                VWWorkflowDefinition wfdef = new VWWorkflowDefinition(true);
                VWXPDL_20_parser.parseXPDLWorkflowProcess(childNode, wfdef, xpdlInfo);
                wfc.addWorkflow(wfdef);
            }
        }
    }

    static void parseXPDLWorkflowProcess(Node aNode, VWWorkflowDefinition wfdef, XPDLInfo xpdlInfo) throws VWException, SAXException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        String idStr = ele.getAttribute("Id");
        String nameStr = ele.getAttributeNode("Name") != null ? ele.getAttribute("Name") : idStr;
        wfdef.setName(nameStr);
        wfdef.originalId = idStr;
        String str = ele.getAttribute("DefaultStartActivitySetId");
        xpdlInfo.defaultStartActivitySetId = str.length() > 0 ? str : "";
        xpdlInfo.partnerLinkNodes = null;
        xpdlInfo.activitySetNodes = null;
        xpdlInfo.mainMapActivitySetId = "";
        boolean foundActivities = false;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            Node childNode;
            int i;
            for (i = 0; i < numChilds; ++i) {
                childNode = childNodes.item(i);
                if (!childNode.getNodeName().equals(m_namespacePrefix + "PartnerLinks")) continue;
                VWXPDL_20_parser.parseXPDLPartnerLinks(childNode, wfdef, xpdlInfo);
            }
            for (i = 0; i < numChilds; ++i) {
                childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (nodeName.equals(m_namespacePrefix + "ProcessHeader")) {
                    VWXPDL_20_parser.parseXPDLProcessHeader(childNode, wfdef, xpdlInfo);
                    continue;
                }
                if (nodeName.equals(m_namespacePrefix + "FormalParameters")) {
                    VWXPDL_20_parser.parseXPDLDataFields("FormalParameter", childNode, wfdef, xpdlInfo, false);
                    continue;
                }
                if (nodeName.equals(m_namespacePrefix + "DataFields")) {
                    VWXPDL_20_parser.parseXPDLDataFields("DataField", childNode, wfdef, xpdlInfo, false);
                    continue;
                }
                if (nodeName.equals(m_namespacePrefix + "ActivitySets")) {
                    if (foundActivities) {
                        throw new VWException("vw.VWXMLHandler.VWActivitySetsAfterActivities", "Invalid syntax in WorkflowProcess \"{0}\". ActivitySets appear after Activities.", nameStr);
                    }
                    VWXPDL_20_parser.parseXPDLActivitySets(childNode, wfdef, xpdlInfo);
                    continue;
                }
                if (nodeName.equals(m_namespacePrefix + "Activities")) {
                    if (foundActivities) {
                        throw new VWException("vw.VWXMLHandler.VWMultipleActivities", "Invalid syntax in WorkflowProcess \"{0}\". More than one Activities element.", nameStr);
                    }
                    VWXPDL_20_parser.setupXpdlInfoForStartEventSearch(xpdlInfo);
                    VWXPDL_20_parser.parseXPDLActivities(childNode, VWXPDL_20_parser.getMainMapFromWorkflow(wfdef), xpdlInfo);
                    foundActivities = true;
                    continue;
                }
                if (nodeName.equals(m_namespacePrefix + "Transitions")) {
                    VWXPDL_20_parser.parseXPDLTransitions(childNode, VWXPDL_20_parser.getMainMapFromWorkflow(wfdef), xpdlInfo);
                    continue;
                }
                if (!nodeName.equals(m_namespacePrefix + "ExtendedAttributes")) continue;
                VWXPDL_20_parser.parseXPDLExtendedAttributes(childNode, VWXPDL_20_parser.getMainMapFromWorkflow(wfdef));
            }
        }
        if (xpdlInfo.packageDataFields != null) {
            VWXPDL_20_parser.parseXPDLDataFields("DataField", xpdlInfo.packageDataFields, wfdef, xpdlInfo, true);
        }
        xpdlInfo.defaultStartActivityId = (str = ele.getAttribute("DefaultStartActivityId")).length() > 0 ? VWXPDL_20_parser.getNewId(str, 1, VWXPDL_20_parser.getMainMapFromWorkflow(wfdef), xpdlInfo) : -1;
        if (foundActivities) {
            VWXPDL_20_parser.fixupMap(VWXPDL_20_parser.getMainMapFromWorkflow(wfdef), xpdlInfo);
        }
    }

    static VWMapDefinition getMainMapFromWorkflow(VWWorkflowDefinition wflDef) throws VWException {
        VWMapDefinition mainMap = null;
        try {
            mainMap = wflDef.getMainMap();
        }
        catch (VWException vWException) {
            // empty catch block
        }
        if (mainMap == null) {
            mainMap = wflDef.createEmptyMap("Workflow");
            mainMap.setMapId(-2);
        }
        return mainMap;
    }

    static void getMaxStepId(Element ele, VWMapDefinition map, String attributeName) throws VWException {
        if (ele.getAttributeNode(attributeName) == null) {
            map.updateNextStepId();
        } else {
            int maxStepId = Integer.parseInt(ele.getAttribute(attributeName));
            if (maxStepId >= map.findHighestStepId()) {
                map.getStepIdGenerator().setNextId(maxStepId + 1);
            } else {
                map.updateNextStepId();
            }
        }
    }

    static void parseXPDLExtendedAttributes(Node aNode, VWMapDefinition map) throws VWException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(m_namespacePrefix + "ExtendedAttribute")) continue;
                Element extendedAttributeElement = (Element)childNode;
                if (extendedAttributeElement.getAttribute("Name").equals("fn:WorkflowName")) {
                    map.setName(extendedAttributeElement.getAttribute("Value"));
                    continue;
                }
                if (extendedAttributeElement.getAttribute("Name").equals("fn:Description")) {
                    map.setDescription(extendedAttributeElement.getAttribute("Value"));
                    continue;
                }
                if (!extendedAttributeElement.getAttribute("Name").equals("fn:MaxStepId")) continue;
                VWXPDL_20_parser.getMaxStepId(extendedAttributeElement, map, "Value");
            }
        }
    }

    static void fixupMap(VWMapDefinition map, XPDLInfo xpdlInfo) throws VWException {
        int i;
        if (xpdlInfo.startActivityIds == null) {
            if (xpdlInfo.startNameActivityId >= 0) {
                xpdlInfo.startActivityIds = new int[1];
                xpdlInfo.startActivityIds[0] = xpdlInfo.startNameActivityId;
            } else {
                xpdlInfo.startActivityIds = new int[0];
            }
        }
        map.updateNextStepId();
        VWString localizedStepName = map.getMapId() == -2 ? new VWString("vw.api.LaunchStepName", "LaunchStep") : new VWString("vw.api.StartStepName", "StartStep");
        if (xpdlInfo.startActivityIds.length == 0) {
            VWStepDefinition step = map.createStep(localizedStepName.toString());
            step.stepId = 0;
        } else {
            VWMapNode startStep;
            if (xpdlInfo.defaultStartActivityId >= 0) {
                for (int i2 = 0; i2 < xpdlInfo.startActivityIds.length; ++i2) {
                    if (xpdlInfo.startActivityIds[i2] != xpdlInfo.defaultStartActivityId) continue;
                    int save0 = xpdlInfo.startActivityIds[0];
                    xpdlInfo.startActivityIds[0] = xpdlInfo.startActivityIds[i2];
                    xpdlInfo.startActivityIds[i2] = save0;
                    break;
                }
            }
            int startStepId = xpdlInfo.startActivityIds[0];
            boolean changeStepId = true;
            if (map.getMapId() == -2 && (startStep = map.getStep(startStepId)) instanceof VWCompoundStepDefinition) {
                VWStepDefinition step = map.createStep(localizedStepName.toString());
                step.stepId = 0;
                step.createRoute(xpdlInfo.startActivityIds[0]);
                changeStepId = false;
            }
            if (changeStepId) {
                xpdlInfo.idInfo[0].isStartStep = true;
                map.getStep(startStepId).setStepId(0);
                VWRouteDefinition[] routes = map.getRoutesByDestinationStep(startStepId);
                if (routes != null) {
                    for (int routeIndex = 0; routeIndex < routes.length; ++routeIndex) {
                        VWMapNode sourceStep = routes[routeIndex].getSourceStep();
                        if (sourceStep == null) continue;
                        sourceStep.deleteRoute(routes[routeIndex].getRouteId());
                    }
                }
                if ((routes = map.getRoutesBySourceStep(startStepId)) != null) {
                    for (int routeIndex = 0; routeIndex < routes.length; ++routeIndex) {
                        routes[routeIndex].setSourceStepId(0);
                    }
                }
                xpdlInfo.startActivityIds[0] = 0;
            }
        }
        map.normalize();
        map.updateNextStepId();
        int ycoord = 50;
        VWXPDL_20_parser.setStepLocations(map, 0, 25, ycoord);
        for (int i3 = 1; i3 < xpdlInfo.startActivityIds.length; ++i3) {
            VWXPDL_20_parser.setStepLocations(map, xpdlInfo.startActivityIds[i3], 125, ycoord += 75);
        }
        if (xpdlInfo.startActivityIds.length == 0) {
            ycoord -= 75;
        }
        VWMapNode[] steps = map.getSteps();
        for (i = 0; i < steps.length; ++i) {
            if (steps[i].getLocation() == null) {
                VWXPDL_20_parser.setStepLocations(map, steps[i].getStepId(), 125, ycoord += 75);
            }
            VWXPDL_20_parser.checkForDuplicateIds(steps[i], steps, map);
        }
        for (i = 0; i < steps.length; ++i) {
            VWRouteDefinition[] routes = map.getRoutesBySourceStep(steps[i].stepId);
            if (routes == null || routes.length <= 1) continue;
            int sourceX = steps[i].getLocation().x;
            int sourceY = steps[i].getLocation().y;
            for (int j = 0; j < routes.length - 1; ++j) {
                Point destLocation1 = routes[j].getDestinationStep().getLocation();
                float slope1 = destLocation1.x != sourceX ? (float)(destLocation1.y - sourceY) / (float)(destLocation1.x - sourceX) : (float)(destLocation1.y - sourceY) / Float.MIN_VALUE;
                for (int k = j + 1; k < routes.length; ++k) {
                    Point destLocation2 = routes[k].getDestinationStep().getLocation();
                    float slope2 = destLocation2.x != sourceX ? (float)(destLocation2.y - sourceY) / (float)(destLocation2.x - sourceX) : (float)(destLocation2.y - sourceY) / Float.MIN_VALUE;
                    if (!((double)Math.abs(slope1 - slope2) < 1.0E-7)) continue;
                    if (slope1 == 0.0f) {
                        sourceY += 15;
                    } else if (slope1 == Float.NEGATIVE_INFINITY || slope1 == Float.POSITIVE_INFINITY) {
                        sourceX += 20;
                    } else {
                        sourceX += 14;
                        sourceY += 14;
                    }
                    slope1 = destLocation1.x != sourceX ? (float)(destLocation1.y - sourceY) / (float)(destLocation1.x - sourceX) : (float)(destLocation1.y - sourceY) / Float.MIN_VALUE;
                }
            }
            steps[i].getLocation().x = sourceX;
            steps[i].getLocation().y = sourceY;
        }
    }

    static void checkForDuplicateIds(VWMapNode mapNode, VWMapNode[] steps, VWMapDefinition map) throws VWException {
        VWInstructionDefinition[] instArray;
        if (mapNode instanceof VWCompoundStepDefinition && (instArray = ((VWCompoundStepDefinition)mapNode).getInstructions()) != null) {
            for (int j = 0; j < instArray.length; ++j) {
                try {
                    VWMapNode tmpMapNode = map.getStep(instArray[j].getInstructionId());
                    if (tmpMapNode != null) {
                        instArray[j].setInstructionId(map.stepIdGenerator.getNextId());
                    }
                }
                catch (VWException ex) {
                    // empty catch block
                }
                for (int k = 0; k < steps.length; ++k) {
                    VWInstructionDefinition[] myInstructionArray;
                    if (mapNode.getStepId() == steps[k].getStepId() || !(steps[k] instanceof VWCompoundStepDefinition) || (myInstructionArray = ((VWCompoundStepDefinition)steps[k]).getInstructions()) == null) continue;
                    for (int m = 0; m < myInstructionArray.length; ++m) {
                        if (instArray[j].getInstructionId() != myInstructionArray[m].getInstructionId()) continue;
                        myInstructionArray[m].setInstructionId(map.stepIdGenerator.getNextId());
                    }
                }
            }
        }
    }

    static boolean setStepLocations(VWMapDefinition map, int firstStepId, int xcoord, int ycoord) throws VWException {
        boolean setThem = false;
        VWMapNode step = map.getStep(firstStepId);
        if (step != null && step.getLocation() == null) {
            step.setLocation(new Point(xcoord, ycoord));
            setThem = true;
            VWRouteDefinition[] routes = step.getNextRoutes();
            if (routes != null) {
                xcoord += 100;
                for (int routeIndex = 0; routeIndex < routes.length; ++routeIndex) {
                    if (!VWXPDL_20_parser.setStepLocations(map, routes[routeIndex].getDestinationStepId(), xcoord, ycoord)) continue;
                    ycoord += 75;
                }
            }
        }
        return setThem;
    }

    static void setAnnotationLocations(VWMapDefinition map) throws VWException {
        int xcoord = 50;
        VWTextAnnotationDefinition[] tads = map.getTextAnnotations();
        if (tads != null) {
            int i;
            for (i = 0; i < tads.length; ++i) {
                if (tads[i].getLocation() != null) continue;
                Point point = null;
                VWAssociationDefinition[] associations = tads[i].getAllAssociations();
                if (associations != null && associations.length > 0) {
                    VWRouteDefinition route;
                    int targetId = -1;
                    int targetType = 1;
                    for (int a = 0; a < associations.length; ++a) {
                        if (associations[a].getTargetType() != targetType) continue;
                        targetId = associations[a].getTargetId();
                        break;
                    }
                    if (targetId == -1) {
                        targetId = associations[0].getTargetId();
                        targetType = associations[0].getTargetType();
                    }
                    if (targetType == 1) {
                        VWMapNode step = map.getStep(targetId);
                        if (step != null) {
                            point = new Point(step.getLocation());
                            point.x -= 48;
                        }
                    } else if (targetType == 2 && (route = map.getRoute(targetId)) != null) {
                        Point sourceLoc = map.getRoute(targetId).getSourceStep().getLocation();
                        Point destinationLoc = map.getRoute(targetId).getDestinationStep().getLocation();
                        if (sourceLoc != null && destinationLoc != null) {
                            point = new Point((sourceLoc.x + destinationLoc.x) / 2, (sourceLoc.y + destinationLoc.y) / 2);
                            point.x -= 56;
                        }
                    }
                }
                if (point == null) {
                    tads[i].setLocation(new Point(xcoord, 300));
                    xcoord += 150;
                    continue;
                }
                point.y += 150;
                if (point.x < 0) {
                    point.x = 0;
                }
                tads[i].setLocation(point);
            }
            for (i = 0; i < tads.length - 1; ++i) {
                for (int j = i + 1; j < tads.length; ++j) {
                    if (!tads[i].getLocation().equals(tads[j].getLocation())) continue;
                    tads[j].getLocation().x += 17;
                    tads[j].getLocation().y += 17;
                }
            }
        }
    }

    static void parseXPDLProcessHeader(Node aNode, VWWorkflowDefinition wfdef, XPDLInfo xpdlInfo) throws VWException, SAXException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (nodeName.equals(m_namespacePrefix + "Description")) {
                    String description = VWXMLHandler.getXMLString(childNode);
                    if (description == null || description.length() <= 0) continue;
                    wfdef.setDescription(description);
                    continue;
                }
                if (!nodeName.equals("fn:WorkflowDefinition")) continue;
                VWXPDL_20_parser.parseXPDLfnWorkflowDefinition(childNode, wfdef, xpdlInfo);
            }
        }
    }

    static void parseXPDLArtifactsAndAssociations(Node artifactsNode, Node associationsNode, VWWorkflowCollectionDefinition wfc, XPDLInfo xpdlInfo) throws VWException {
        int numChilds;
        if (artifactsNode.getNodeType() != 1) {
            return;
        }
        Element artifactsElement = (Element)artifactsNode;
        NodeList childNodes = artifactsElement.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Element artifactElement;
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(m_namespacePrefix + "Artifact") || !(artifactElement = (Element)childNode).getAttribute("ArtifactType").equals("Annotation")) continue;
                String idStr = artifactElement.getAttribute("Id");
                VWTextAnnotationDefinition tad = new VWTextAnnotationDefinition(null, VWXPDL_20_parser.createNewId(idStr, 4, null, xpdlInfo), artifactElement.getAttribute("TextAnnotation"), null, null, false);
                VWXPDL_20_parser.parseXPDLTextAnnotation(artifactElement, tad);
                if (artifactElement.getAttributeNode("fn:workflow") == null || artifactElement.getAttributeNode("fn:map") == null) {
                    VWXPDL_20_parser.searchAssociations(idStr, tad, associationsNode, wfc, xpdlInfo);
                    continue;
                }
                VWWorkflowDefinition wfdef = wfc.getWorkflow(artifactElement.getAttribute("fn:workflow"));
                VWMapDefinition map = wfdef.getMap(artifactElement.getAttribute("fn:map"));
                VWXPDL_20_parser.createTextAnnotationInMap(tad, map);
            }
        }
    }

    static void parseXPDLTextAnnotation(Element artifactElement, VWTextAnnotationDefinition tad) throws VWException {
        int numChilds;
        NodeList childNodes;
        if (artifactElement.getAttributeNode("Name") != null) {
            tad.setName(artifactElement.getAttribute("Name"));
        }
        if ((childNodes = artifactElement.getChildNodes()) != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(m_namespacePrefix + "NodeGraphicsInfos")) continue;
                NodeGraphicsInfo ngi = VWXPDL_20_parser.parseXPDLNodeGraphicsInfos(childNode);
                if (ngi != null) {
                    tad.setLocation(ngi.point);
                    tad.setBgColor(ngi.color);
                    tad.setDimension(ngi.dimension);
                    tad.setMinimized(ngi.minimized);
                }
                tad.setOriginalNodeGraphicsInfosNode(childNode);
                break;
            }
        }
    }

    static void searchAssociations(String taIdStr, VWTextAnnotationDefinition tad, Node associationsNode, VWWorkflowCollectionDefinition wfc, XPDLInfo xpdlInfo) throws VWException {
        VWWorkflowDefinition[] wfdefs;
        int numChilds;
        Element associationsElement;
        NodeList childNodes;
        boolean foundTextAnnotationInAssociations = false;
        if (associationsNode != null && associationsNode.getNodeType() == 1 && (childNodes = (associationsElement = (Element)associationsNode).getChildNodes()) != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                VWMapDefinition map;
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(m_namespacePrefix + "Association")) continue;
                Element associationElement = (Element)childNode;
                Node connectorGraphicsInfosNode = null;
                NodeList cgiList = associationElement.getElementsByTagName("ConnectorGraphicsInfos");
                if (cgiList != null && cgiList.getLength() == 1) {
                    connectorGraphicsInfosNode = cgiList.item(0);
                }
                String targetIdStr = associationElement.getAttribute("Target");
                String sourceIdStr = associationElement.getAttribute("Source");
                int nTargetItemIndex = -1;
                if (targetIdStr.equals(taIdStr)) {
                    foundTextAnnotationInAssociations = true;
                    nTargetItemIndex = VWXPDL_20_parser.findIndexOfItem(sourceIdStr, xpdlInfo);
                } else if (sourceIdStr.equals(taIdStr)) {
                    foundTextAnnotationInAssociations = true;
                    nTargetItemIndex = VWXPDL_20_parser.findIndexOfItem(targetIdStr, xpdlInfo);
                }
                if (nTargetItemIndex < 0 || (map = xpdlInfo.idInfo[nTargetItemIndex].map) == null) continue;
                VWTextAnnotationDefinition newTextAnnotation = null;
                VWTextAnnotationDefinition[] textAnnoDefs = map.getTextAnnotations();
                if (textAnnoDefs != null) {
                    for (int t = 0; t < textAnnoDefs.length; ++t) {
                        if (textAnnoDefs[t].getId() != tad.getId()) continue;
                        newTextAnnotation = textAnnoDefs[t];
                        break;
                    }
                }
                if (newTextAnnotation == null) {
                    newTextAnnotation = VWXPDL_20_parser.createTextAnnotationInMap(tad, map);
                }
                int nTargetId = xpdlInfo.idInfo[nTargetItemIndex].isStartStep ? 0 : xpdlInfo.idInfo[nTargetItemIndex].nNewId;
                int targetType = xpdlInfo.idInfo[nTargetItemIndex].objectType == 1 ? 1 : 2;
                VWAssociationDefinition assoc = newTextAnnotation.createAssociation(nTargetId, targetType);
                if (associationElement.getAttributeNode("Name") != null) {
                    assoc.setName(associationElement.getAttribute("Name"));
                }
                assoc.setOriginalConnectorGraphicsInfosNode(connectorGraphicsInfosNode);
            }
        }
        if (!foundTextAnnotationInAssociations && (wfdefs = wfc.getWorkflows()) != null) {
            for (int i = 0; i < wfdefs.length; ++i) {
                VWXPDL_20_parser.createTextAnnotationInMap(tad, wfdefs[i].getMainMap());
            }
        }
    }

    static VWTextAnnotationDefinition createTextAnnotationInMap(VWTextAnnotationDefinition tad, VWMapDefinition map) throws VWException {
        VWTextAnnotationDefinition newTextAnnotation = map.createTextAnnotation(tad.getMessage(), tad.getLocation(), tad.getDimension(), tad.isMinimized());
        newTextAnnotation.setId(tad.getId());
        newTextAnnotation.setName(tad.getName());
        newTextAnnotation.setBgColor(tad.getBgColor());
        newTextAnnotation.setOriginalNodeGraphicsInfosNode(tad.getOriginalNodeGraphicsInfosNode());
        return newTextAnnotation;
    }

    static void parseXPDLfnWorkflowDefinition(Node aNode, VWWorkflowDefinition wfdef, XPDLInfo xpdlInfo) throws VWException, SAXException {
        int numChilds;
        NodeList childNodes;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        if (ele.getAttributeNode("Subject") != null) {
            wfdef.setSubject(ele.getAttribute("Subject"));
        }
        if (ele.getAttributeNode("Deadline") != null) {
            wfdef.setDeadline(Long.parseLong(ele.getAttribute("Deadline")));
        }
        if (ele.getAttributeNode("Reminder") != null) {
            wfdef.setReminder(Long.parseLong(ele.getAttribute("Reminder")));
        }
        if (ele.getAttributeNode("DisableEmailNotification") != null) {
            wfdef.setDisableEmailNotification(VWXMLHandler.stringToBoolean(ele.getAttribute("DisableEmailNotification")));
        }
        if (ele.getAttributeNode("MainAttachment") != null) {
            wfdef.setMainAttachmentNameNoValidate(ele.getAttribute("MainAttachment"));
        }
        if (ele.getAttributeNode("BaseWorkClass") != null) {
            wfdef.setBaseWorkClassName(ele.getAttribute("BaseWorkClass"));
        }
        if (ele.getAttributeNode("Roster") != null) {
            wfdef.setRosterName(ele.getAttribute("Roster"));
        }
        if (ele.getAttributeNode("EventLog") != null) {
            wfdef.setEventLogName(ele.getAttribute("EventLog"));
        }
        if (ele.getAttributeNode("Tag") != null) {
            wfdef.setTag(ele.getAttribute("Tag"));
        }
        if (ele.getAttributeNode("IncomingWSAttachmentFolder") != null) {
            wfdef.setIncomingWSAttachmentFolder(ele.getAttribute("IncomingWSAttachmentFolder"));
        }
        if (ele.getAttributeNode("AuthorTool") != null) {
            wfdef.setAuthorTool(ele.getAttribute("AuthorTool"));
        }
        if (ele.getAttributeNode("OtherAuthorTools") != null) {
            wfdef.setOtherAuthorTools(ele.getAttribute("OtherAuthorTools"));
        }
        if (ele.getAttributeNode("versionAgnostic") != null) {
            wfdef.setVersionAgnostic(VWXMLHandler.stringToBoolean(ele.getAttribute("versionAgnostic")));
        }
        if (ele.getAttributeNode("validateUsingSchema") != null) {
            wfdef.setValidateUsingSchema(VWXMLHandler.stringToBoolean(ele.getAttribute("validateUsingSchema")));
        }
        if (ele.getAttributeNode("validateFlag") != null) {
            wfdef.setValidateFlag(VWXMLHandler.stringToBoolean(ele.getAttribute("validateFlag")));
        }
        if (ele.getAttributeNode("transferFlag") != null) {
            wfdef.setTransferFlag(VWXMLHandler.stringToBoolean(ele.getAttribute("transferFlag")));
        }
        if (ele.getAttributeNode("ActivitySetId") != null) {
            String activitySetIdStr = ele.getAttribute("ActivitySetId");
            xpdlInfo.mainMapActivitySetId = activitySetIdStr.length() > 0 ? activitySetIdStr : "";
        }
        if ((childNodes = ele.getChildNodes()) != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getLocalName();
                if (nodeName == null) continue;
                if (nodeName.equals("Milestone")) {
                    VWXML_CUR_parser.parseXMLMilestoneDefinition(childNode, wfdef);
                    continue;
                }
                if (nodeName.equals("ModelAttributes")) {
                    Hashtable attributes = VWXML_CUR_parser.parseXMLModelAttributes(childNode);
                    wfdef.setAttributes(attributes);
                    continue;
                }
                if (nodeName.equals("RuleSet")) {
                    VWXML_CUR_parser.parseXMLRuleSetDefinition(childNode, wfdef);
                    continue;
                }
                if (nodeName.equals("types")) {
                    VWXML_CUR_parser.parseXMLSchemas(childNode, wfdef);
                    continue;
                }
                if (!nodeName.equals("WFRuntimeId")) continue;
                VWXML_CUR_parser.parseXMLRuntimeId(childNode, wfdef);
            }
        }
    }

    static void parseXPDLDataFields(String nodeNameStr, Node aNode, VWWorkflowDefinition wfdef, XPDLInfo xpdlInfo, boolean isPackageField) throws VWException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(nodeNameStr)) continue;
                VWXPDL_20_parser.parseXPDLDataField(childNode, wfdef, xpdlInfo, isPackageField);
            }
        }
    }

    static void parseXPDLDataField(Node aNode, VWWorkflowDefinition wfdef, XPDLInfo xpdlInfo, boolean isPackageField) throws VWException {
        int numChilds;
        String nameStr;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        String idStr = ele.getAttribute("Id");
        boolean isFromName = false;
        if (ele.getAttributeNode("Name") == null) {
            nameStr = idStr;
        } else {
            nameStr = ele.getAttribute("Name").replaceAll(" ", "");
            isFromName = true;
        }
        nameStr = VWXPDL_20_parser.makeValidFieldName(nameStr);
        boolean isUnique = true;
        VWFieldDefinition[] fldDefs = wfdef.getFields();
        if (fldDefs != null) {
            for (int i = 0; i < fldDefs.length; ++i) {
                if (!fldDefs[i].name.equals(nameStr)) continue;
                isUnique = false;
                break;
            }
        }
        if (!isUnique) {
            if (isPackageField) {
                return;
            }
            if (isFromName) {
                nameStr = nameStr + "_" + idStr;
            }
        }
        boolean isArray = VWXMLHandler.stringToBoolean(ele.getAttribute("IsArray"));
        int typeInt = 0;
        String valueStr = null;
        String description = null;
        String mergeType = null;
        String elementName = null;
        String schemaName = null;
        String requiredClass = null;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (nodeName.equals(m_namespacePrefix + "DataType")) {
                    typeInt = VWXPDL_20_parser.parseXPDLDataType(childNode);
                    continue;
                }
                if (nodeName.equals(m_namespacePrefix + "InitialValue")) {
                    valueStr = VWXMLHandler.getXMLString(childNode);
                    continue;
                }
                if (nodeName.equals(m_namespacePrefix + "Description")) {
                    description = VWXMLHandler.getXMLString(childNode);
                    continue;
                }
                if (!nodeName.equals("fn:Field")) continue;
                Element fnFieldElement = (Element)childNode;
                if (fnFieldElement.getAttributeNode("ElementName") != null) {
                    elementName = fnFieldElement.getAttribute("ElementName");
                }
                if (fnFieldElement.getAttributeNode("MergeType") != null) {
                    mergeType = fnFieldElement.getAttribute("MergeType");
                }
                if (fnFieldElement.getAttributeNode("SchemaName") != null) {
                    schemaName = fnFieldElement.getAttribute("SchemaName");
                }
                if (fnFieldElement.getAttributeNode("RequiredClass") == null) continue;
                requiredClass = fnFieldElement.getAttribute("RequiredClass");
            }
        }
        if (typeInt != 0) {
            if (valueStr == null || valueStr.equals("")) {
                valueStr = VWXPDL_20_parser.getDefaultTypeValue(typeInt, isArray);
            }
            VWFieldDefinition fldDef = nameStr.equals("F_Trackers") ? wfdef.createFieldNoValidateName(nameStr, valueStr, typeInt, isArray) : wfdef.createFieldUsingString(nameStr, valueStr, typeInt, isArray);
            if (description != null && description.trim().length() > 0) {
                fldDef.setDescription(description);
            }
            if (mergeType != null) {
                fldDef.setMergeType(VWMergeType.stringToType(mergeType));
            }
            if (elementName != null) {
                fldDef.setXMLSchemaElement(elementName);
            }
            if (schemaName != null) {
                fldDef.setXMLSchemaName(schemaName);
            }
            if (requiredClass != null) {
                fldDef.setRequiredClass(new VWGuid(requiredClass));
            }
        }
    }

    static String makeValidFieldName(String nameStr) {
        StringBuffer newName = new StringBuffer();
        for (int i = 0; i < nameStr.length(); ++i) {
            char ch = nameStr.charAt(i);
            if (!Character.isLetterOrDigit(ch) && ch != '_') continue;
            newName.append(ch);
        }
        if (newName.length() == 0 || !Character.isLetter(newName.charAt(0))) {
            newName = new StringBuffer("Field" + newName.toString());
        }
        return newName.toString();
    }

    static String getDefaultTypeValue(int typeInt, boolean isArray) {
        String valueStr = typeInt == 1 ? "0" : (typeInt == 4 ? "false" : (typeInt == 8 ? "0.0" : (typeInt == 16 ? "systemtime()" : "\"\"")));
        if (isArray) {
            valueStr = "{" + valueStr + "}";
        }
        return valueStr;
    }

    static int parseXPDLDataType(Node aNode) {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return 0;
        }
        Element ele = (Element)aNode;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                String typeStr;
                Element typeElement;
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (nodeName.equals(m_namespacePrefix + "BasicType")) {
                    typeElement = (Element)childNode;
                    typeStr = typeElement.getAttribute("Type");
                    if (typeStr == null) continue;
                    if (typeStr.equals("INTEGER")) {
                        return 1;
                    }
                    if (typeStr.equals("STRING")) {
                        return 2;
                    }
                    if (typeStr.equals("BOOLEAN")) {
                        return 4;
                    }
                    if (typeStr.equals("FLOAT")) {
                        return 8;
                    }
                    if (!typeStr.equals("DATETIME")) continue;
                    return 16;
                }
                if (!nodeName.equals(m_namespacePrefix + "DeclaredType") || (typeStr = (typeElement = (Element)childNode).getAttribute("Id")) == null) continue;
                if (typeStr.equals("attachment")) {
                    return 32;
                }
                if (typeStr.equals("participant")) {
                    return 64;
                }
                if (typeStr.equals("xml")) {
                    return 128;
                }
                if (!typeStr.equals("ceobject")) continue;
                return 512;
            }
        }
        return 2;
    }

    static void parseXPDLActivitySets(Node aNode, VWWorkflowDefinition wfdef, XPDLInfo xpdlInfo) throws VWException, SAXException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            xpdlInfo.activitySetNodes = childNodes;
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(m_namespacePrefix + "ActivitySet")) continue;
                VWXPDL_20_parser.parseXPDLActivitySet(childNode, wfdef, xpdlInfo);
            }
        }
    }

    static String lookupActivitySetName(String activitySetIdStr, XPDLInfo xpdlInfo) {
        NodeList activitySetNodes = xpdlInfo.activitySetNodes;
        if (activitySetNodes != null) {
            int numChilds = activitySetNodes.getLength();
            for (int i = 0; i < numChilds; ++i) {
                Element activitySetElement;
                String idStr;
                Node childNode = activitySetNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(m_namespacePrefix + "ActivitySet") || !(idStr = (activitySetElement = (Element)childNode).getAttribute("Id")).equals(activitySetIdStr)) continue;
                String nameStr = activitySetElement.getAttribute("Name");
                if (nameStr.length() == 0) {
                    nameStr = activitySetIdStr;
                }
                return nameStr;
            }
        }
        if (activitySetIdStr != null && activitySetIdStr.equals(xpdlInfo.mainMapActivitySetId)) {
            return "Workflow";
        }
        return activitySetIdStr;
    }

    static void parseXPDLPartnerLinks(Node aNode, VWWorkflowDefinition wfdef, XPDLInfo xpdlInfo) throws VWException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            xpdlInfo.partnerLinkNodes = childNodes;
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(m_namespacePrefix + "PartnerLink")) continue;
                VWXPDL_20_parser.parseXPDLPartnerLink(childNode, wfdef, xpdlInfo);
            }
        }
    }

    static void parseXPDLPartnerLink(Node aNode, VWWorkflowDefinition wfdef, XPDLInfo xpdlInfo) throws VWException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        String partnerLinkTypeId = ele.getAttribute("PartnerLinkTypeId");
        VWPartnerLinkDefinition partnerLink = wfdef.createPartnerLink(ele.getAttribute("name"));
        String myRoleName = null;
        String partnerRoleName = null;
        try {
            partnerLink.setPartnerLinkRef(ele.getAttribute("fn:PartnerLinkRef"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                int prNumChilds;
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (nodeName.equals(m_namespacePrefix + "MyRole")) {
                    Element myRoleElement = (Element)childNode;
                    myRoleName = myRoleElement.getAttribute("RoleName");
                    partnerLink.setMyRole(myRoleName);
                    continue;
                }
                if (!nodeName.equals(m_namespacePrefix + "PartnerRole")) continue;
                Element partnerRoleElement = (Element)childNode;
                partnerRoleName = partnerRoleElement.getAttribute("RoleName");
                partnerLink.setPartnerRole(partnerRoleName);
                NodeList prChildNodes = partnerRoleElement.getChildNodes();
                if (prChildNodes == null || (prNumChilds = prChildNodes.getLength()) == 0) continue;
                for (int j = 0; j < prNumChilds; ++j) {
                    int epNumChilds;
                    Node prChildNode = prChildNodes.item(j);
                    String prNodeName = prChildNode.getNodeName();
                    if (!prNodeName.equals(m_namespacePrefix + "EndPoint")) continue;
                    Element endpointElement = (Element)prChildNode;
                    try {
                        partnerLink.setWSDLRef(endpointElement.getAttribute("fn:WSDLRef"));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    NodeList epChildNodes = endpointElement.getChildNodes();
                    if (epChildNodes == null || (epNumChilds = epChildNodes.getLength()) == 0) continue;
                    for (int k = 0; k < epNumChilds; ++k) {
                        Node epChildNode = epChildNodes.item(k);
                        String epNodeName = epChildNode.getNodeName();
                        if (!epNodeName.equals(m_namespacePrefix + "ExternalReference")) continue;
                        Element externalReferenceElement = (Element)epChildNode;
                        partnerLink.setPartnerEndPoint(externalReferenceElement.getAttribute("location"));
                    }
                }
            }
            VWXPDL_20_parser.setPartnerLinkPortTypes(myRoleName, partnerRoleName, partnerLinkTypeId, xpdlInfo.partnerLinkTypeNodes, partnerLink);
        }
    }

    static void setPartnerLinkPortTypes(String myRoleName, String partnerRoleName, String partnerLinkTypeId, NodeList partnerLinkTypeNodes, VWPartnerLinkDefinition partnerLink) throws VWException {
        if (partnerLinkTypeNodes == null) {
            return;
        }
        int numChilds = partnerLinkTypeNodes.getLength();
        for (int i = 0; i < numChilds; ++i) {
            int pltNumChildren;
            Element partnerLinkTypeElement;
            Node childNode = partnerLinkTypeNodes.item(i);
            String nodeName = childNode.getNodeName();
            if (!nodeName.equals(m_namespacePrefix + "PartnerLinkType") || !(partnerLinkTypeElement = (Element)childNode).getAttribute("Id").equals(partnerLinkTypeId)) continue;
            NodeList pltChildren = partnerLinkTypeElement.getChildNodes();
            if (pltChildren != null && (pltNumChildren = pltChildren.getLength()) != 0) {
                for (int j = 0; j < pltNumChildren; ++j) {
                    Node pltChildNode = pltChildren.item(j);
                    String pltNodeName = pltChildNode.getNodeName();
                    if (!pltNodeName.equals(m_namespacePrefix + "Role")) continue;
                    Element roleElement = (Element)pltChildNode;
                    String roleName = roleElement.getAttribute("Name");
                    String portType = roleElement.getAttribute("portType");
                    if (myRoleName != null && roleName.equals(myRoleName)) {
                        partnerLink.setMyPortType(portType);
                        continue;
                    }
                    if (partnerRoleName == null || !roleName.equals(partnerRoleName)) continue;
                    partnerLink.setPartnerPortType(portType);
                }
            }
            return;
        }
    }

    static String lookupPartnerLinkName(String partnerLinkIdStr, NodeList partnerLinkNodes) {
        if (partnerLinkNodes == null) {
            return null;
        }
        int numChilds = partnerLinkNodes.getLength();
        for (int i = 0; i < numChilds; ++i) {
            Element partnerLinkElement;
            Node childNode = partnerLinkNodes.item(i);
            String nodeName = childNode.getNodeName();
            if (!nodeName.equals(m_namespacePrefix + "PartnerLink") || !(partnerLinkElement = (Element)childNode).getAttribute("Id").equals(partnerLinkIdStr)) continue;
            return partnerLinkElement.getAttribute("name");
        }
        return null;
    }

    static void parseXPDLActivitySet(Node aNode, VWWorkflowDefinition wfdef, XPDLInfo xpdlInfo) throws VWException, SAXException {
        String str;
        int numChilds;
        VWMapDefinition map;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        String idStr = ele.getAttribute("Id");
        if (idStr == null || idStr.length() == 0) {
            return;
        }
        String nameStr = ele.getAttribute("Name");
        if (nameStr == null || nameStr.length() == 0) {
            nameStr = idStr;
        }
        if (xpdlInfo.defaultStartActivitySetId.equals(idStr)) {
            map = VWXPDL_20_parser.getMainMapFromWorkflow(wfdef);
        } else {
            map = wfdef.createEmptyMap(nameStr);
            try {
                map.setMapId(Integer.parseInt(idStr));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        VWXPDL_20_parser.setupXpdlInfoForStartEventSearch(xpdlInfo);
        if (ele.getAttributeNode("fn:Description") != null) {
            map.setDescription(ele.getAttribute("fn:Description"));
        }
        VWXPDL_20_parser.getMaxStepId(ele, map, "fn:MaxStepId");
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (nodeName.equals(m_namespacePrefix + "Activities")) {
                    VWXPDL_20_parser.parseXPDLActivities(childNode, map, xpdlInfo);
                    continue;
                }
                if (!nodeName.equals(m_namespacePrefix + "Transitions")) continue;
                VWXPDL_20_parser.parseXPDLTransitions(childNode, map, xpdlInfo);
            }
        }
        if ((str = ele.getAttribute("DefaultStartActivityId")) != null && str.length() > 0) {
            xpdlInfo.defaultStartActivityId = VWXPDL_20_parser.getNewId(str, 1, map, xpdlInfo);
        }
        VWXPDL_20_parser.fixupMap(map, xpdlInfo);
    }

    static void setupXpdlInfoForStartEventSearch(XPDLInfo xpdlInfo) {
        xpdlInfo.defaultStartActivityId = -1;
        xpdlInfo.startActivityIds = null;
        xpdlInfo.startNameActivityId = -1;
    }

    static void parseXPDLActivities(Node aNode, VWMapDefinition map, XPDLInfo xpdlInfo) throws VWException, SAXException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(m_namespacePrefix + "Activity")) continue;
                VWXPDL_20_parser.parseXPDLActivity(childNode, map, xpdlInfo);
            }
        }
    }

    static void parseXPDLActivity(Node aNode, VWMapDefinition map, XPDLInfo xpdlInfo) throws VWException, SAXException {
        int i;
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        String idStr = ele.getAttribute("Id");
        int stepId = VWXPDL_20_parser.createNewId(idStr, 1, map, xpdlInfo);
        String nameStr = null;
        if (ele.getAttributeNode("Name") != null) {
            nameStr = ele.getAttribute("Name");
        }
        VWMapNode step = map.createEmptyStep();
        step.setStepId(stepId);
        step.setName(nameStr);
        boolean bIsFileNetCompoundStep = false;
        if (ele.getAttribute("fn:CompoundStep").equals("true")) {
            step = VWXPDL_20_parser.changeToCompoundStep(step, xpdlInfo);
            bIsFileNetCompoundStep = true;
        }
        if (ele.getAttributeNode("fn:AuthorTool") != null) {
            step.setAuthorTool(ele.getAttribute("fn:AuthorTool"));
        }
        if (xpdlInfo.startNameActivityId < 0 && nameStr != null && nameStr.equalsIgnoreCase("start")) {
            xpdlInfo.startNameActivityId = stepId;
        }
        boolean isStartActivity = VWXMLHandler.stringToBoolean(ele.getAttribute("StartActivity"));
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            String nodeName;
            Node childNode;
            Node assignmentsNode = null;
            for (i = 0; i < numChilds; ++i) {
                childNode = childNodes.item(i);
                nodeName = childNode.getNodeName();
                if (!nodeName.equals(m_namespacePrefix + "Assignments")) continue;
                assignmentsNode = childNode;
                VWXPDL_20_parser.parseXPDLAssignments(assignmentsNode, step, "Start", xpdlInfo);
            }
            for (i = 0; i < numChilds; ++i) {
                childNode = childNodes.item(i);
                nodeName = childNode.getNodeName();
                if (nodeName.equals(m_namespacePrefix + "Description")) {
                    String description = VWXMLHandler.getXMLString(childNode);
                    if (description == null || description.length() <= 0) continue;
                    step.setDescription(description);
                    continue;
                }
                if (nodeName.equals(m_namespacePrefix + "Implementation")) {
                    step = VWXPDL_20_parser.parseXPDLActivityImplementation(childNode, step, xpdlInfo);
                    continue;
                }
                if (nodeName.equals(m_namespacePrefix + "BlockActivity")) {
                    if ((step = VWXPDL_20_parser.changeToCompoundStep(step, xpdlInfo)) == null) continue;
                    VWXPDL_20_parser.parseXPDLBlockActivity(childNode, (VWCompoundStepDefinition)step, xpdlInfo);
                    continue;
                }
                if (nodeName.equals(m_namespacePrefix + "Event")) {
                    int nEventType = -1;
                    if (!isStartActivity) {
                        nEventType = VWXPDL_20_parser.parseXPDLEvent(childNode);
                    }
                    switch (nEventType) {
                        case 0: {
                            isStartActivity = true;
                            break;
                        }
                        case 1: {
                            step = VWXPDL_20_parser.changeToCompoundStep(step, xpdlInfo);
                            if (step == null || !(step instanceof VWCompoundStepDefinition)) break;
                            String dummyID = step.stepId + ".0";
                            map.stepIdGenerator.setNextId(VWXPDL_20_parser.createNewId(dummyID, 3, map, xpdlInfo));
                            if (!bIsFileNetCompoundStep && map.name != null && !map.name.contentEquals("Workflow")) {
                                ((VWCompoundStepDefinition)step).createReturnInstruction("false");
                                break;
                            }
                            ((VWCompoundStepDefinition)step).createTerminateBranchInstruction();
                        }
                    }
                    continue;
                }
                if (nodeName.equals(m_namespacePrefix + "Performers") && step instanceof VWStepDefinition) {
                    VWXPDL_20_parser.parseXPDLPerformers(childNode, (VWStepDefinition)step);
                    continue;
                }
                if (nodeName.equals(m_namespacePrefix + "Deadline") && step instanceof VWStepDefinition) {
                    VWXPDL_20_parser.parseXPDLDeadline(childNode, (VWStepDefinition)step);
                    continue;
                }
                if (nodeName.equals(m_namespacePrefix + "TransitionRestrictions")) {
                    VWXPDL_20_parser.parseXPDLTransitionRestrictions(childNode, step);
                    continue;
                }
                if (nodeName.equals(m_namespacePrefix + "NodeGraphicsInfos")) {
                    NodeGraphicsInfo ngi = VWXPDL_20_parser.parseXPDLNodeGraphicsInfos(childNode);
                    if (ngi != null) {
                        step.setLocation(ngi.point);
                    }
                    step.setOriginalNodeGraphicsInfosNode(childNode);
                    continue;
                }
                if (nodeName.equals("fn:Step")) {
                    VWXPDL_20_parser.parseXPDLfnStep(childNode, (VWStepDefinition)step);
                    continue;
                }
                if (nodeName.equals("fn:CompoundStep")) {
                    if ((step = VWXPDL_20_parser.changeToCompoundStep(step, xpdlInfo)) == null) continue;
                    VWXPDL_20_parser.parseXPDLfnCompoundStep(childNode, (VWCompoundStepDefinition)step, xpdlInfo);
                    continue;
                }
                if (!nodeName.equals("fn:AuthorTool")) continue;
                step.setAuthorTool(childNode.getNodeValue());
            }
            if (assignmentsNode != null) {
                VWXPDL_20_parser.parseXPDLAssignments(assignmentsNode, step, "End", xpdlInfo);
            }
        }
        if (isStartActivity) {
            if (xpdlInfo.startActivityIds == null) {
                xpdlInfo.startActivityIds = new int[1];
                xpdlInfo.startActivityIds[0] = stepId;
            } else {
                int[] oldStartActivityIds = xpdlInfo.startActivityIds;
                xpdlInfo.startActivityIds = new int[oldStartActivityIds.length + 1];
                for (i = 0; i < oldStartActivityIds.length; ++i) {
                    xpdlInfo.startActivityIds[i] = oldStartActivityIds[i];
                }
                xpdlInfo.startActivityIds[oldStartActivityIds.length] = stepId;
            }
        }
    }

    static int createNewId(String idStr, int objectType, VWMapDefinition map, XPDLInfo xpdlInfo) throws VWException {
        if (xpdlInfo.idInfo == null) {
            xpdlInfo.idInfo = new IDInfo[1];
        } else {
            for (int i = 0; i < xpdlInfo.idInfo.length; ++i) {
                if (!xpdlInfo.idInfo[i].idStr.equals(idStr) || xpdlInfo.idInfo[i].objectType != objectType || map != null && xpdlInfo.idInfo[i].map != map) continue;
                String str = "Id";
                switch (objectType) {
                    case 1: {
                        str = "Activity Id";
                        break;
                    }
                    case 2: {
                        str = "Transition Id";
                        break;
                    }
                    case 3: {
                        str = "Instruction Id";
                        break;
                    }
                    case 4: {
                        str = "TextAnnotation Id";
                    }
                }
                str = str + " \"" + idStr + "\"";
                if (map != null) {
                    throw new VWException("vw.VWXMLHandler.VWDuplicateXPDLId1", "Duplicate XPDL {0} in WorkflowProcess {1}.", str, map.getWorkflow().getName());
                }
                throw new VWException("vw.VWXMLHandler.VWDuplicateXPDLId2", "Duplicate XPDL {0}.", str);
            }
            IDInfo[] oldIdInfo = xpdlInfo.idInfo;
            xpdlInfo.idInfo = new IDInfo[oldIdInfo.length + 1];
            for (int i = 0; i < oldIdInfo.length; ++i) {
                xpdlInfo.idInfo[i] = oldIdInfo[i];
            }
        }
        int nNewId = -1;
        try {
            int nIndex;
            String subString = null;
            switch (objectType) {
                case 1: {
                    subString = "mapnode";
                    break;
                }
                case 2: {
                    subString = "route";
                    break;
                }
                case 3: {
                    subString = "Instruction-";
                    break;
                }
                case 4: {
                    subString = "Artifact";
                }
            }
            if (subString != null && (nIndex = idStr.lastIndexOf(subString)) != -1) {
                nNewId = Integer.parseInt(idStr.substring(nIndex + subString.length()));
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        int nInfoIndex = xpdlInfo.idInfo.length - 1;
        if (nNewId == -1) {
            nNewId = nInfoIndex + 1;
        }
        xpdlInfo.idInfo[nInfoIndex] = new IDInfo();
        xpdlInfo.idInfo[nInfoIndex].idStr = idStr;
        xpdlInfo.idInfo[nInfoIndex].objectType = objectType;
        xpdlInfo.idInfo[nInfoIndex].map = map;
        xpdlInfo.idInfo[nInfoIndex].isStartStep = false;
        xpdlInfo.idInfo[nInfoIndex].nNewId = nNewId;
        return nNewId;
    }

    static int getNewId(String idStr, int objectType, VWMapDefinition map, XPDLInfo xpdlInfo) throws VWException {
        if (map != null && xpdlInfo.idInfo != null) {
            for (int i = 0; i < xpdlInfo.idInfo.length; ++i) {
                if (!xpdlInfo.idInfo[i].idStr.equals(idStr) || map != xpdlInfo.idInfo[i].map || objectType != xpdlInfo.idInfo[i].objectType) continue;
                return xpdlInfo.idInfo[i].nNewId;
            }
        }
        return -1;
    }

    static int findIndexOfItem(String idStr, XPDLInfo xpdlInfo) throws VWException {
        if (xpdlInfo.idInfo != null) {
            for (int nIndex = 0; nIndex < xpdlInfo.idInfo.length; ++nIndex) {
                if (!xpdlInfo.idInfo[nIndex].idStr.equals(idStr)) continue;
                return nIndex;
            }
        }
        return -1;
    }

    static int parseXPDLEvent(Node aNode) {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return -1;
        }
        Element ele = (Element)aNode;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (nodeName.equals(m_namespacePrefix + "StartEvent")) {
                    return 0;
                }
                if (!nodeName.equals(m_namespacePrefix + "EndEvent")) continue;
                return 1;
            }
        }
        return -1;
    }

    static VWMapNode parseXPDLActivityImplementation(Node aNode, VWMapNode step, XPDLInfo xpdlInfo) throws VWException, SAXException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return step;
        }
        Element ele = (Element)aNode;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (nodeName.equals(m_namespacePrefix + "SubFlow")) {
                    if ((step = VWXPDL_20_parser.changeToCompoundStep(step, xpdlInfo)) == null) continue;
                    VWXPDL_20_parser.parseXPDLSubflow(childNode, (VWCompoundStepDefinition)step, xpdlInfo);
                    continue;
                }
                if (!nodeName.equals(m_namespacePrefix + "Task")) continue;
                step = VWXPDL_20_parser.parseXPDLTask(childNode, step, xpdlInfo);
            }
        }
        return step;
    }

    static void parseXPDLSubflow(Node aNode, VWCompoundStepDefinition step, XPDLInfo xpdlInfo) throws VWException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        String idStr = ele.getAttribute("Id");
        String[] workflowInfo = VWXPDL_20_parser.getWorkflowInfo(idStr, xpdlInfo.workflowProcessNodes);
        if (workflowInfo == null) {
            throw new VWException("vw.VWXMLHandler.VWInvalidXPDLSubFlow", "The XPDL SubFlow Id {0} could not be found as a WorkflowProcess.", idStr);
        }
        String nameStr = ele.getAttribute("Name");
        if (nameStr.length() == 0) {
            nameStr = workflowInfo[0];
        }
        String[][] parameters = null;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(m_namespacePrefix + "ActualParameters")) continue;
                parameters = VWXPDL_20_parser.parseXPDLParametersForSubflow(childNode, workflowInfo);
            }
        }
        VWInstructionDefinition instruction = step.createCreateInstruction(nameStr, parameters);
        String instructionIdStr = step.getMap().getWorkflow().getName() + "-" + step.getMap().getName() + "-Step-" + step.getStepId() + "-CreateInstruction";
        instruction.setInstructionId(VWXPDL_20_parser.createNewId(instructionIdStr, 3, step.getMap(), xpdlInfo));
    }

    static String[] getWorkflowInfo(String idStr, NodeList workflowProcessNodes) {
        int numChilds = 0;
        if (workflowProcessNodes != null) {
            numChilds = workflowProcessNodes.getLength();
        }
        for (int i = 0; i < numChilds; ++i) {
            int wfNumChilds;
            Element workflowProcessElement;
            Node childNode = workflowProcessNodes.item(i);
            String nodeName = childNode.getNodeName();
            if (!nodeName.equals(m_namespacePrefix + "WorkflowProcess") || !(workflowProcessElement = (Element)childNode).getAttribute("Id").equals(idStr)) continue;
            String nameStr = workflowProcessElement.getAttribute("Name");
            if (nameStr == null || nameStr.length() == 0) {
                nameStr = idStr;
            }
            String[] wfInfo = new String[]{nameStr};
            NodeList childNodes = workflowProcessElement.getChildNodes();
            if (childNodes != null && (wfNumChilds = childNodes.getLength()) != 0) {
                for (int wfi = 0; wfi < wfNumChilds; ++wfi) {
                    int fpsNumChilds;
                    Node wfChildNode = childNodes.item(wfi);
                    String wfNodeName = wfChildNode.getNodeName();
                    if (!wfNodeName.equals(m_namespacePrefix + "FormalParameters")) continue;
                    Element formalParametersElement = (Element)wfChildNode;
                    NodeList fpChildNodes = formalParametersElement.getChildNodes();
                    if (fpChildNodes == null || (fpsNumChilds = fpChildNodes.getLength()) == 0) break;
                    for (int fpsi = 0; fpsi < fpsNumChilds; ++fpsi) {
                        Node fpsChildNode = fpChildNodes.item(fpsi);
                        String fpsNodeName = fpsChildNode.getNodeName();
                        if (!fpsNodeName.equals(m_namespacePrefix + "FormalParameter")) continue;
                        Element formalParameterElement = (Element)fpsChildNode;
                        String parmIdStr = formalParameterElement.getAttribute("Id");
                        String modeStr = formalParameterElement.getAttribute("Mode");
                        String[] oldWfInfo = wfInfo;
                        wfInfo = new String[wfInfo.length + 1];
                        for (int pos = 0; pos < oldWfInfo.length; ++pos) {
                            wfInfo[pos] = oldWfInfo[pos];
                        }
                        if (modeStr.equals("IN") || modeStr.length() == 0) {
                            wfInfo[pos] = "<" + parmIdStr;
                            continue;
                        }
                        if (modeStr.equals("OUT")) {
                            wfInfo[pos] = ">" + parmIdStr;
                            continue;
                        }
                        if (!modeStr.equals("INOUT")) continue;
                        wfInfo[pos] = "+" + parmIdStr;
                    }
                    break;
                }
            }
            return wfInfo;
        }
        return null;
    }

    static String[][] parseXPDLParametersForSubflow(Node aNode, String[] workflowInfo) throws VWException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return null;
        }
        Element ele = (Element)aNode;
        String[][] parameters = null;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            int wfInfoIndex = 1;
            int parmNum = 0;
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(m_namespacePrefix + "ActualParameter") || wfInfoIndex >= workflowInfo.length) continue;
                if (workflowInfo[wfInfoIndex].startsWith("<") || workflowInfo[wfInfoIndex].startsWith("+")) {
                    if (parameters == null) {
                        parameters = new String[1][2];
                    } else {
                        String[][] oldParameters = parameters;
                        parameters = new String[parmNum + 1][2];
                        for (int j = 0; j < oldParameters.length; ++j) {
                            parameters[j] = oldParameters[j];
                        }
                    }
                    parameters[parmNum][0] = workflowInfo[wfInfoIndex].substring(1);
                    parameters[parmNum][1] = VWXMLHandler.getXMLString(childNode);
                    ++parmNum;
                }
                ++wfInfoIndex;
            }
        }
        return parameters;
    }

    static VWMapNode parseXPDLTask(Node aNode, VWMapNode step, XPDLInfo xpdlInfo) throws VWException, SAXException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return step;
        }
        Element ele = (Element)aNode;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (nodeName.equals(m_namespacePrefix + "TaskService") || nodeName.equals(m_namespacePrefix + "TaskReceive") || nodeName.equals(m_namespacePrefix + "TaskSend")) {
                    if ((step = VWXPDL_20_parser.changeToCompoundStep(step, xpdlInfo)) == null) continue;
                    VWXPDL_20_parser.parseXPDLTaskFunction(nodeName, childNode, (VWCompoundStepDefinition)step, xpdlInfo);
                    continue;
                }
                if (!nodeName.equals(m_namespacePrefix + "TaskApplication")) continue;
                VWXPDL_20_parser.parseXPDLTaskApplication(childNode, (VWStepDefinition)step);
            }
        }
        return step;
    }

    static void parseXPDLTaskFunction(String function, Node aNode, VWCompoundStepDefinition step, XPDLInfo xpdlInfo) throws VWException, SAXException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        String implementation = ele.getAttribute("Implementation");
        if (implementation != null && implementation.length() > 0 && !implementation.equals("WebService")) {
            return;
        }
        Node messageInNode = null;
        Node messageOutNode = null;
        Node messageNode = null;
        Node webServiceOperationNode = null;
        Node fnInstructionNode = null;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (nodeName.equals(m_namespacePrefix + "MessageIn")) {
                    messageInNode = childNode;
                    continue;
                }
                if (nodeName.equals(m_namespacePrefix + "MessageOut")) {
                    messageOutNode = childNode;
                    continue;
                }
                if (nodeName.equals(m_namespacePrefix + "Message")) {
                    messageNode = childNode;
                    continue;
                }
                if (nodeName.equals(m_namespacePrefix + "WebServiceOperation")) {
                    webServiceOperationNode = childNode;
                    continue;
                }
                if (!nodeName.equals("fn:InvokeParameters") && !nodeName.equals("fn:ReceiveParameters") && !nodeName.equals("fn:ReplyParameters")) continue;
                fnInstructionNode = childNode;
            }
        }
        if (webServiceOperationNode != null) {
            VWXPDL_20_parser.parseXPDLWebServiceOperation(function, webServiceOperationNode, messageInNode, messageOutNode, messageNode, fnInstructionNode, childNodes, step, xpdlInfo);
        }
    }

    static void parseXPDLWebServiceOperation(String function, Node webServiceOperationNode, Node messageInNode, Node messageOutNode, Node messageNode, Node fnInstructionNode, NodeList taskFunctionChildNodes, VWCompoundStepDefinition step, XPDLInfo xpdlInfo) throws VWException, SAXException {
        String instructionIdStr;
        int numChilds;
        if (webServiceOperationNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)webServiceOperationNode;
        String operationName = ele.getAttribute("OperationName");
        String partnerLinkName = null;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(m_namespacePrefix + "Partner")) continue;
                Element partnerElement = (Element)childNode;
                String partnerLinkId = partnerElement.getAttribute("PartnerLinkId");
                partnerLinkName = VWXPDL_20_parser.lookupPartnerLinkName(partnerLinkId, xpdlInfo.partnerLinkNodes);
            }
        }
        if (function.equals(m_namespacePrefix + "TaskService")) {
            VWInvokeInstruction invokeInstruction = (VWInvokeInstruction)step.createInvokeInstruction(partnerLinkName, operationName);
            instructionIdStr = step.getMap().getWorkflow().getName() + "-" + step.getMap().getName() + "-Step-" + step.getStepId() + "-InvokeInstruction";
            invokeInstruction.setInstructionId(VWXPDL_20_parser.createNewId(instructionIdStr, 3, step.getMap(), xpdlInfo));
            if (messageInNode != null) {
                VWXPDL_20_parser.parseXPDLWebServiceMessage(messageInNode, true, invokeInstruction);
            }
            if (messageOutNode != null) {
                VWXPDL_20_parser.parseXPDLWebServiceMessage(messageOutNode, false, invokeInstruction);
            }
            if (fnInstructionNode != null) {
                VWXPDL_20_parser.parseXPDLFnInstructionNodeForInvoke(fnInstructionNode, invokeInstruction);
            }
            VWXPDL_20_parser.parseXPDLWebServiceFaultCatches(taskFunctionChildNodes, invokeInstruction, xpdlInfo);
        } else if (function.equals(m_namespacePrefix + "TaskReceive")) {
            VWReceiveInstruction receiveInstruction = (VWReceiveInstruction)step.createReceiveInstruction(partnerLinkName, operationName);
            instructionIdStr = step.getMap().getWorkflow().getName() + "-" + step.getMap().getName() + "-Step-" + step.getStepId() + "-ReceiveInstruction";
            receiveInstruction.setInstructionId(VWXPDL_20_parser.createNewId(instructionIdStr, 3, step.getMap(), xpdlInfo));
            if (messageNode != null) {
                VWXPDL_20_parser.parseXPDLWebServiceMessage(messageNode, true, receiveInstruction);
            }
            if (fnInstructionNode != null) {
                VWXPDL_20_parser.parseXPDLFnInstructionNodeForReceive(fnInstructionNode, receiveInstruction);
            }
        } else if (function.equals(m_namespacePrefix + "TaskSend")) {
            VWReplyInstruction replyInstruction = (VWReplyInstruction)step.createReplyInstruction(partnerLinkName, operationName);
            instructionIdStr = step.getMap().getWorkflow().getName() + "-" + step.getMap().getName() + "-Step-" + step.getStepId() + "-ReplyInstruction";
            replyInstruction.setInstructionId(VWXPDL_20_parser.createNewId(instructionIdStr, 3, step.getMap(), xpdlInfo));
            if (messageNode != null) {
                VWXPDL_20_parser.parseXPDLWebServiceMessage(messageNode, false, replyInstruction);
            }
            if (fnInstructionNode != null) {
                VWXPDL_20_parser.parseXPDLFnInstructionNodeForReply(fnInstructionNode, replyInstruction);
            }
        }
    }

    static void parseXPDLWebServiceMessage(Node aNode, boolean isInput, IVWHasWSParameterDefs instruction) throws VWException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(m_namespacePrefix + "ActualParameters")) continue;
                VWXPDL_20_parser.parseXPDLParametersForWebService(childNode, isInput, instruction);
            }
        }
    }

    static void parseXPDLParametersForWebService(Node aNode, boolean isInput, IVWHasWSParameterDefs instruction) throws VWException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(m_namespacePrefix + "ActualParameter") && !nodeName.equals("fn:ActualParameter")) continue;
                Element paramElement = (Element)childNode;
                String fnName = paramElement.getAttribute("fn:Name");
                String fnSourceStr = paramElement.getAttribute("fn:Source");
                int nFnTypeInt = -1;
                if (paramElement.getAttributeNode("fn:Type") != null) {
                    nFnTypeInt = VWFieldType.stringToType(paramElement.getAttribute("fn:Type"));
                }
                boolean isArray = VWXMLHandler.stringToBoolean(paramElement.getAttribute("fn:IsArray"));
                String valueStr = VWXMLHandler.getXMLString(childNode);
                if (valueStr != null && valueStr.length() == 0) {
                    valueStr = null;
                }
                VWWebServiceParameterDefinition wsParam = null;
                if (instruction instanceof VWInvokeInstruction) {
                    if (isInput) {
                        if (fnName != null && nFnTypeInt != -1) {
                            wsParam = ((VWInvokeInstruction)instruction).createOutGoingParameter(fnName, valueStr, nFnTypeInt, isArray);
                        } else {
                            if (fnName != null) {
                                ((VWInvokeInstruction)instruction).setOutputMsgName(fnName);
                            }
                            ((VWInvokeInstruction)instruction).setOutputMsgExpr(valueStr);
                        }
                    } else if (fnName != null && nFnTypeInt != -1) {
                        wsParam = ((VWInvokeInstruction)instruction).createInComingParameter(fnName, valueStr, nFnTypeInt, isArray);
                    } else {
                        if (fnName != null) {
                            ((VWInvokeInstruction)instruction).setInputMsgName(fnName);
                        }
                        ((VWInvokeInstruction)instruction).setInputMsgExpr(valueStr);
                    }
                } else if (instruction instanceof VWReceiveInstruction) {
                    if (fnSourceStr == null || fnSourceStr.length() == 0) {
                        wsParam = ((VWReceiveInstruction)instruction).createParameter(fnName, valueStr, nFnTypeInt, isArray);
                    } else if (fnSourceStr.equals("Expression")) {
                        ((VWReceiveInstruction)instruction).setMessageExpr(valueStr);
                    } else if (fnSourceStr.equals("Schema")) {
                        ((VWReceiveInstruction)instruction).setMessageFromSchemaName(valueStr);
                    } else if (fnSourceStr.equals("Element")) {
                        ((VWReceiveInstruction)instruction).setMessageFromElementName(valueStr);
                    }
                } else if (instruction instanceof VWReplyInstruction) {
                    if (fnSourceStr == null || fnSourceStr.length() == 0) {
                        wsParam = ((VWReplyInstruction)instruction).createParameter(fnName, valueStr, nFnTypeInt, isArray);
                    } else if (fnSourceStr.equals("Expression")) {
                        ((VWReplyInstruction)instruction).setMessageExpr(valueStr);
                    } else if (fnSourceStr.equals("Schema")) {
                        ((VWReplyInstruction)instruction).setMessageFromSchemaName(valueStr);
                    } else if (fnSourceStr.equals("Element")) {
                        ((VWReplyInstruction)instruction).setMessageFromElementName(valueStr);
                    }
                }
                if (wsParam == null) continue;
                if (paramElement.getAttributeNode("fn:NameSpace") != null) {
                    wsParam.setNameSpace(paramElement.getAttributeNode("fn:NameSpace").getValue());
                }
                if (paramElement.getAttributeNode("fn:Attributes") != null) {
                    wsParam.setAttributes(paramElement.getAttributeNode("fn:Attributes").getValue());
                }
                if (paramElement.getAttributeNode("fn:ArrayTag") != null) {
                    wsParam.setArrayTag(paramElement.getAttributeNode("fn:ArrayTag").getValue());
                }
                if (paramElement.getAttributeNode("fn:ArrayNameSpace") != null) {
                    wsParam.setArrayNameSpace(paramElement.getAttributeNode("fn:ArrayNameSpace").getValue());
                }
                if (paramElement.getAttributeNode("fn:ArrayAttributes") != null) {
                    wsParam.setArrayAttributes(paramElement.getAttributeNode("fn:ArrayAttributes").getValue());
                }
                if (paramElement.getAttributeNode("fn:LexicalLevel") != null) {
                    wsParam.setLexicalLevel(Integer.parseInt(paramElement.getAttributeNode("fn:LexicalLevel").getValue()));
                }
                if (paramElement.getAttributeNode("fn:Sequence") != null) {
                    wsParam.setSequenceNumber(Integer.parseInt(paramElement.getAttributeNode("fn:Sequence").getValue()));
                }
                if (paramElement.getAttributeNode("fn:AttachmentByValue") != null) {
                    wsParam.setAttachmentByValue(VWXMLHandler.stringToBoolean(paramElement.getAttributeNode("fn:AttachmentByValue").getValue()));
                }
                if (paramElement.getAttributeNode("fn:SchemaSubType") == null) continue;
                wsParam.setSchemaSubType(VWXMLSchemaSubType.stringToType(paramElement.getAttributeNode("fn:SchemaSubType").getValue()));
            }
        }
    }

    static void parseXPDLWebServiceFaultCatches(NodeList taskFunctionChildNodes, VWInvokeInstruction invokeInstruction, XPDLInfo xpdlInfo) throws VWException {
        int numChilds = 0;
        if (taskFunctionChildNodes != null) {
            numChilds = taskFunctionChildNodes.getLength();
        }
        for (int i = 0; i < numChilds; ++i) {
            Node childNode = taskFunctionChildNodes.item(i);
            String nodeName = childNode.getNodeName();
            if (!nodeName.equals(m_namespacePrefix + "WebServiceFaultCatch")) continue;
            VWXPDL_20_parser.parseXPDLWebServiceFaultCatch(childNode, invokeInstruction, xpdlInfo);
        }
    }

    static void parseXPDLWebServiceFaultCatch(Node aNode, VWInvokeInstruction invokeInstruction, XPDLInfo xpdlInfo) throws VWException {
        String nodeName;
        Node childNode;
        int i;
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        String faultName = null;
        if (ele.getAttributeNode("FaultName") != null) {
            faultName = ele.getAttribute("FaultName");
        }
        boolean isCatchAll = VWXMLHandler.stringToBoolean(ele.getAttribute("fn:CatchAll"));
        VWFaultDefinition fault = null;
        Node messageNode = null;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (i = 0; i < numChilds; ++i) {
                childNode = childNodes.item(i);
                nodeName = childNode.getNodeName();
                if (nodeName.equals(m_namespacePrefix + "BlockActivity")) {
                    Element baElement = (Element)childNode;
                    String activitySetIdStr = baElement.getAttribute("ActivitySetId");
                    String mapNameStr = VWXPDL_20_parser.lookupActivitySetName(activitySetIdStr, xpdlInfo);
                    if (isCatchAll) {
                        invokeInstruction.setCatchAllMap(mapNameStr);
                        continue;
                    }
                    fault = invokeInstruction.createFault(faultName, null, mapNameStr);
                    continue;
                }
                if (!nodeName.equals(m_namespacePrefix + "Message") || childNode.getNodeType() != 1) continue;
                messageNode = childNode;
            }
        }
        if (messageNode != null && (isCatchAll || fault != null) && (childNodes = (ele = (Element)messageNode).getChildNodes()) != null && (numChilds = childNodes.getLength()) != 0) {
            for (i = 0; i < numChilds; ++i) {
                childNode = childNodes.item(i);
                nodeName = childNode.getNodeName();
                if (!nodeName.equals(m_namespacePrefix + "ActualParameters")) continue;
                VWXPDL_20_parser.parseXPDLParametersForFault(childNode, isCatchAll, invokeInstruction, fault);
            }
        }
    }

    static void parseXPDLParametersForFault(Node aNode, boolean isCatchAll, VWInvokeInstruction invokeInstruction, VWFaultDefinition fault) throws VWException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(m_namespacePrefix + "ActualParameter")) continue;
                if (isCatchAll) {
                    invokeInstruction.setCatchAllOutput(VWXMLHandler.getXMLString(childNode));
                    continue;
                }
                fault.setFaultMessage(VWXMLHandler.getXMLString(childNode));
            }
        }
    }

    static void parseXPDLFnInstructionNodeForInvoke(Node fnInstructionNode, VWInvokeInstruction invokeInstruction) throws VWException, SAXException {
        int numChilds;
        if (fnInstructionNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)fnInstructionNode;
        if (ele.getAttributeNode("timeout") != null) {
            invokeInstruction.setTimeoutExpr(ele.getAttribute("timeout"));
        }
        if (ele.getAttributeNode("timeoutMap") != null) {
            invokeInstruction.setTimeoutMapName(ele.getAttribute("timeoutMap"));
        }
        invokeInstruction.setUseReliableMessaging(VWXMLHandler.stringToBoolean(ele.getAttribute("useReliableMessaging")));
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                CorrSet cs;
                String subNodeName;
                Node subNode;
                int j;
                NodeList subNodes;
                Node childNode = childNodes.item(i);
                String childNodeName = childNode.getNodeName();
                if (childNodeName.equals("inputCorrelationSet")) {
                    subNodes = childNode.getChildNodes();
                    for (j = 0; j < subNodes.getLength(); ++j) {
                        subNode = subNodes.item(j);
                        subNodeName = subNode.getNodeName();
                        if (!subNodeName.equals("correlationSet") || (cs = VWXML_CUR_parser.parseXMLCorrelationSet(subNode)) == null) continue;
                        invokeInstruction.setInputCorrelationSetName(cs.getName());
                        invokeInstruction.setInputCorrelationSetProperties(cs.getProperties());
                    }
                    continue;
                }
                if (!childNodeName.equals(m_namespacePrefix + "outputCorrelationSet")) continue;
                subNodes = childNode.getChildNodes();
                for (j = 0; j < subNodes.getLength(); ++j) {
                    subNode = subNodes.item(j);
                    subNodeName = subNode.getNodeName();
                    if (!subNodeName.equals("correlationSet") || (cs = VWXML_CUR_parser.parseXMLCorrelationSet(subNode)) == null) continue;
                    invokeInstruction.setOutputCorrelationSetName(cs.getName());
                    invokeInstruction.setOutputCorrelationSetProperties(cs.getProperties());
                }
            }
        }
    }

    static void parseXPDLFnInstructionNodeForReceive(Node fnInstructionNode, VWReceiveInstruction receiveInstruction) throws VWException, SAXException {
        int numChilds;
        NodeList childNodes;
        if (fnInstructionNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)fnInstructionNode;
        if (ele.getAttributeNode("timeout") != null) {
            receiveInstruction.setTimeoutExpr(ele.getAttribute("timeout"));
        }
        if (ele.getAttributeNode("timeoutMap") != null) {
            receiveInstruction.setTimeoutMapName(ele.getAttribute("timeoutMap"));
        }
        if (ele.getAttributeNode("correlationValueExpression") != null) {
            receiveInstruction.setCorrelationValueExpression(ele.getAttribute("correlationValueExpression"));
        }
        if (ele.getAttributeNode("correlationParameterSequenceNumber") != null) {
            receiveInstruction.setCorrelationParameterSequenceNumber(Integer.parseInt(ele.getAttribute("correlationParameterSequenceNumber")));
        }
        if (ele.getAttributeNode("authentication") != null) {
            receiveInstruction.setAuthentication(VWXMLHandler.stringToBoolean(ele.getAttribute("authentication")));
        }
        if ((childNodes = ele.getChildNodes()) != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                NodeList childNodesSG;
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (nodeName.equals("correlationSet")) {
                    CorrSet cs = VWXML_CUR_parser.parseXMLCorrelationSet(childNode);
                    if (cs == null) continue;
                    receiveInstruction.setCorrelationSetName(cs.getName());
                    receiveInstruction.setCorrelationSetProperties(cs.getProperties());
                    continue;
                }
                if (!nodeName.equals("securityGroup") || (childNodesSG = childNode.getChildNodes()).getLength() <= 0) continue;
                Vector<String> secGrpVector = new Vector<String>();
                for (int j = 0; j < childNodesSG.getLength(); ++j) {
                    Node childNodeSG = childNodesSG.item(j);
                    String childNodeSGName = childNodeSG.getNodeName();
                    if (!childNodeSGName.equals("Expression")) continue;
                    Element eleSG = (Element)childNodeSG;
                    String sgExpr = null;
                    if (eleSG.getAttributeNode("Val") != null) {
                        sgExpr = eleSG.getAttribute("Val");
                    }
                    if (sgExpr == null) continue;
                    secGrpVector.add(sgExpr);
                }
                receiveInstruction.setSecurityGroup(secGrpVector.toArray(new String[0]));
            }
        }
    }

    static void parseXPDLFnInstructionNodeForReply(Node fnInstructionNode, VWReplyInstruction replyInstruction) throws VWException, SAXException {
        int numChilds;
        NodeList childNodes;
        if (fnInstructionNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)fnInstructionNode;
        if (ele.getAttributeNode("FaultName") != null) {
            replyInstruction.setFaultName(ele.getAttribute("FaultName"));
        }
        if (ele.getAttributeNode("hasAttachments") != null) {
            replyInstruction.setHasAttachments(VWXMLHandler.stringToBoolean(ele.getAttribute("hasAttachments")));
        }
        if ((childNodes = ele.getChildNodes()) != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                CorrSet cs;
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals("correlationSet") || (cs = VWXML_CUR_parser.parseXMLCorrelationSet(childNode)) == null) continue;
                replyInstruction.setCorrelationSetName(cs.getName());
                replyInstruction.setCorrelationSetProperties(cs.getProperties());
            }
        }
    }

    static void parseXPDLTaskApplication(Node aNode, VWStepDefinition step) throws VWException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(m_namespacePrefix + "DataMappings")) continue;
                VWXPDL_20_parser.parseXPDLDataMappings(childNode, step);
            }
        }
    }

    static void parseXPDLDataMappings(Node aNode, VWStepDefinition step) throws VWException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(m_namespacePrefix + "DataMapping")) continue;
                VWXPDL_20_parser.parseXPDLDataMapping(childNode, step);
            }
        }
    }

    static void parseXPDLDataMapping(Node aNode, VWStepDefinition step) throws VWException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        String nameStr = VWXPDL_20_parser.makeValidFieldName(ele.getAttribute("Formal"));
        int directionInt = 1;
        if (ele.getAttributeNode("Direction") != null) {
            directionInt = VWModeType.stringToType(ele.getAttribute("Direction").toLowerCase());
        }
        String valueStr = null;
        int typeInt = 2;
        boolean isArray = false;
        String description = null;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (nodeName.equals(m_namespacePrefix + "Actual")) {
                    valueStr = VWXMLHandler.getXMLString(childNode);
                    continue;
                }
                if (!nodeName.equals(m_namespacePrefix + "fn:Parameter")) continue;
                Element fnParameterElement = (Element)childNode;
                typeInt = VWFieldType.stringToType(fnParameterElement.getAttribute("Type"));
                isArray = VWXMLHandler.stringToBoolean(fnParameterElement.getAttribute("IsArray"));
                if (fnParameterElement.getAttributeNode("Description") == null) continue;
                description = fnParameterElement.getAttribute("Description");
            }
        }
        if (valueStr == null || valueStr.length() == 0) {
            valueStr = VWXPDL_20_parser.getDefaultTypeValue(typeInt, isArray);
        }
        int stepId = step.stepId;
        if (nameStr.equals("F_Trackers")) {
            step.stepId = 0;
        }
        VWParameterDefinition parameter = step.createParameter(nameStr, directionInt, valueStr, typeInt, isArray);
        step.stepId = stepId;
        if (description != null) {
            parameter.setDescription(description);
        }
    }

    static void parseXPDLPerformers(Node aNode, VWStepDefinition step) throws VWException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            VWArrayHandler partHandler = new VWArrayHandler(1, 1);
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(m_namespacePrefix + "Performer")) continue;
                step.setParticipants((VWParticipant[])partHandler.addElementToArray(step.getParticipants(), new VWParticipant(VWXMLHandler.getXMLString(childNode))));
            }
            VWParticipant[] participants = step.getParticipants();
            if (participants != null && participants.length > 0) {
                step.setQueueName("Inbox");
            }
        }
    }

    static boolean isCompoundStep(VWStepDefinition step) throws VWException {
        VWMapNode mapNode = step.getMap().getStep(step.stepId);
        return mapNode instanceof VWCompoundStepDefinition;
    }

    static VWMapNode changeToCompoundStep(VWMapNode step, XPDLInfo xpdlInfo) throws VWException {
        VWMapNode mapNode = step.getMap().getStep(step.stepId);
        if (mapNode instanceof VWCompoundStepDefinition) {
            return mapNode;
        }
        String deadline = ((VWStepDefinition)step).getDeadlineExpr();
        if (deadline != null && deadline.length() != 0) {
            return null;
        }
        String[][] preAssignments = ((VWStepDefinition)step).getPreAssignments();
        VWMapNode changedStep = step.getMap().changeStepType(step.stepId);
        if (changedStep != null && preAssignments != null && preAssignments.length != 0) {
            VWInstructionDefinition instruction = ((VWCompoundStepDefinition)changedStep).createAssignInstruction(preAssignments);
            String instructionIdStr = step.getMap().getWorkflow().getName() + "-" + step.getMap().getName() + "-Step-" + step.getStepId() + "-StartAssignInstruction";
            instruction.setInstructionId(VWXPDL_20_parser.createNewId(instructionIdStr, 3, step.getMap(), xpdlInfo));
        }
        return changedStep;
    }

    static void parseXPDLDeadline(Node aNode, VWStepDefinition step) throws VWException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return;
        }
        if (VWXPDL_20_parser.isCompoundStep(step)) {
            return;
        }
        Element ele = (Element)aNode;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (nodeName.equals(m_namespacePrefix + "DeadlineDuration")) {
                    String deadline = VWXMLHandler.getXMLString(childNode);
                    deadline = deadline.replaceAll(" Minutes", "");
                    deadline = deadline.replaceAll(" " + VWTimeUnitType.getLocalizedString(1), "");
                    step.setDeadlineExpr(deadline);
                    continue;
                }
                if (!nodeName.equals(m_namespacePrefix + "ExceptionName")) continue;
                step.setDeadlineMap(VWXMLHandler.getXMLString(childNode));
            }
        }
    }

    static NodeGraphicsInfo parseXPDLNodeGraphicsInfos(Node aNode) throws VWException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return null;
        }
        Element ele = (Element)aNode;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                NodeGraphicsInfo ngi;
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(m_namespacePrefix + "NodeGraphicsInfo") || (ngi = VWXPDL_20_parser.parseXPDLNodeGraphicsInfo(childNode)) == null) continue;
                return ngi;
            }
        }
        return null;
    }

    static NodeGraphicsInfo parseXPDLNodeGraphicsInfo(Node aNode) throws VWException {
        int numChilds;
        NodeList childNodes;
        String[] rgbStrs;
        if (aNode.getNodeType() != 1) {
            return null;
        }
        Element ele = (Element)aNode;
        if (!ele.getAttribute("ToolId").equals("FileNetPE")) {
            return null;
        }
        NodeGraphicsInfo ngi = new NodeGraphicsInfo();
        if (ele.getAttributeNode("FillColor") != null && (rgbStrs = ele.getAttribute("FillColor").split(",")).length == 3) {
            ngi.color = new Color(Integer.parseInt(rgbStrs[0]), Integer.parseInt(rgbStrs[1]), Integer.parseInt(rgbStrs[2]));
        }
        if (ele.getAttributeNode("Width") != null && ele.getAttributeNode("Height") != null) {
            ngi.dimension = new Dimension(Integer.parseInt(ele.getAttribute("Width")), Integer.parseInt(ele.getAttribute("Height")));
        }
        ngi.minimized = false;
        if (ele.getAttributeNode("IsVisible") != null) {
            boolean bl = ngi.minimized = !VWXMLHandler.stringToBoolean(ele.getAttribute("IsVisible"));
        }
        if ((childNodes = ele.getChildNodes()) != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(m_namespacePrefix + "Coordinates")) continue;
                Element coordElement = (Element)childNode;
                String XStr = coordElement.getAttribute("XCoordinate");
                String YStr = coordElement.getAttribute("YCoordinate");
                if (XStr.length() <= 0 || YStr.length() <= 0) continue;
                ngi.point = new Point(Integer.parseInt(XStr), Integer.parseInt(YStr));
            }
        }
        if (ngi.point != null) {
            return ngi;
        }
        return null;
    }

    static void writeXPDLNodeGraphicsInfos(Point location, Dimension dimension, Color fillColor, boolean minimized, Object originalNodeGraphicsInfosNode, String indentA, StringBuffer theBuffer) {
        int numChilds;
        Element ele;
        NodeList childNodes;
        String indentB = VWXMLHandler.incXMLIndent(indentA);
        String indentC = VWXMLHandler.incXMLIndent(indentB);
        theBuffer.append(indentA + "<NodeGraphicsInfos>\n");
        if (originalNodeGraphicsInfosNode != null && ((Node)originalNodeGraphicsInfosNode).getNodeType() == 1 && (childNodes = (ele = (Element)originalNodeGraphicsInfosNode).getChildNodes()) != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(m_namespacePrefix + "NodeGraphicsInfo") || ((Element)childNode).getAttribute("ToolId").equals("FileNetPE")) continue;
                VWXMLHandler.writeXMLNode(childNode, indentB, theBuffer);
            }
        }
        theBuffer.append(indentB + "<NodeGraphicsInfo ToolId=\"FileNetPE\"");
        if (dimension != null) {
            theBuffer.append(" Width=\"" + Integer.toString(dimension.width) + "\"" + " Height=\"" + Integer.toString(dimension.height) + "\"");
        }
        if (fillColor != null) {
            theBuffer.append(" FillColor=\"" + Integer.toString(fillColor.getRed()) + "," + Integer.toString(fillColor.getGreen()) + "," + Integer.toString(fillColor.getBlue()) + "\"");
        }
        if (minimized) {
            theBuffer.append(" IsVisible=\"" + VWXMLHandler.booleanToString(!minimized) + "\"");
        }
        theBuffer.append(">\n");
        if (location != null) {
            theBuffer.append(indentC + "<Coordinates XCoordinate=\"" + Integer.toString(location.x) + "\" " + "YCoordinate=\"" + Integer.toString(location.y) + "\"/>\n");
        }
        theBuffer.append(indentB + "</NodeGraphicsInfo>\n");
        theBuffer.append(indentA + "</NodeGraphicsInfos>\n");
    }

    static void writeXPDLPools(VWWorkflowCollectionDefinition wfc, String indentA, StringBuffer theBuffer) throws VWException {
        Node originalPoolsNode = (Node)wfc.getOriginalPoolsNode();
        if (originalPoolsNode != null && originalPoolsNode.getNodeType() == 1) {
            Element poolElement;
            int i;
            Element ele = (Element)originalPoolsNode;
            NodeList poolNodes = ele.getElementsByTagName("Pool");
            if (poolNodes != null) {
                for (i = 0; i < poolNodes.getLength(); ++i) {
                    poolElement = (Element)poolNodes.item(i);
                    if (poolElement.getAttributeNode("Process") == null) continue;
                    String poolProcessId = poolElement.getAttribute("Process");
                    boolean foundPoolProcessId = false;
                    if (poolProcessId.length() > 0) {
                        VWWorkflowDefinition[] wfdefs = wfc.getWorkflows();
                        for (int w = 0; w < wfdefs.length; ++w) {
                            if (wfdefs[w].originalId == null || !wfdefs[w].originalId.equals(poolProcessId)) continue;
                            poolElement.setAttribute("Process", Integer.toString(w));
                            foundPoolProcessId = true;
                        }
                    }
                    if (foundPoolProcessId) continue;
                    poolElement.setAttribute("Process", "-1");
                }
            }
            VWXMLHandler.writeXMLNode(originalPoolsNode, indentA, theBuffer);
            if (poolNodes != null) {
                for (i = 0; i < poolNodes.getLength(); ++i) {
                    int poolProcessIndex;
                    poolElement = (Element)poolNodes.item(i);
                    if (poolElement.getAttributeNode("Process") == null || (poolProcessIndex = Integer.parseInt(poolElement.getAttribute("Process"))) < 0) continue;
                    VWWorkflowDefinition[] wfdefs = wfc.getWorkflows();
                    poolElement.setAttribute("Process", wfdefs[poolProcessIndex].originalId);
                }
            }
        }
    }

    static void parseXPDLBlockActivity(Node aNode, VWCompoundStepDefinition step, XPDLInfo xpdlInfo) throws VWException {
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        String activitySetIdStr = ele.getAttribute("ActivitySetId");
        String mapNameStr = VWXPDL_20_parser.lookupActivitySetName(activitySetIdStr, xpdlInfo);
        VWInstructionDefinition instruction = step.createCallInstruction(mapNameStr);
        String instructionIdStr = step.getMap().getWorkflow().getName() + "-" + step.getMap().getName() + "-Step-" + step.getStepId() + "-CallInstruction";
        instruction.setInstructionId(VWXPDL_20_parser.createNewId(instructionIdStr, 3, step.getMap(), xpdlInfo));
    }

    static void parseXPDLTransitionRestrictions(Node aNode, VWMapNode step) throws VWException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(m_namespacePrefix + "TransitionRestriction")) continue;
                VWXPDL_20_parser.parseXPDLTransitionRestriction(childNode, step);
            }
        }
    }

    static void parseXPDLTransitionRestriction(Node aNode, VWMapNode step) throws VWException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (nodeName.equals(m_namespacePrefix + "Split")) {
                    Element splitElement = (Element)childNode;
                    String splitType = splitElement.getAttribute("Type");
                    if (splitType.equals("AND")) {
                        step.setSplitType(1);
                        continue;
                    }
                    if (!splitType.equals("XOR")) continue;
                    step.setSplitType(2);
                    continue;
                }
                if (!nodeName.equals(m_namespacePrefix + "Join")) continue;
                Element joinElement = (Element)childNode;
                String joinType = joinElement.getAttribute("Type");
                if (joinType.equals("AND") || joinType.equals("OR")) {
                    step.setJoinType(1);
                    continue;
                }
                if (!joinType.equals("XOR")) continue;
                step.setJoinType(2);
            }
        }
    }

    static void parseXPDLfnStep(Node aNode, VWStepDefinition step) throws VWException, SAXException {
        int numChilds;
        NodeList childNodes;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        if (ele.getAttributeNode("RequestedInterface") != null) {
            step.setRequestedInterface(ele.getAttribute("RequestedInterface"));
        }
        if (ele.getAttributeNode("QueueName") != null) {
            step.setQueueName(ele.getAttribute("QueueName"));
        }
        if (ele.getAttributeNode("PreMilestone") != null) {
            step.setPreMilestone(ele.getAttribute("PreMilestone"));
        }
        if (ele.getAttributeNode("PostMilestone") != null) {
            step.setPostMilestone(ele.getAttribute("PostMilestone"));
        }
        if (ele.getAttributeNode("Reminder") != null) {
            step.setReminder(Long.parseLong(ele.getAttribute("Reminder")));
        }
        if (ele.getAttributeNode("CanReassign") != null) {
            step.setCanReassign(VWXMLHandler.stringToBoolean(ele.getAttribute("CanReassign")));
        }
        if (ele.getAttributeNode("CanViewStatus") != null) {
            step.setCanViewStatus(VWXMLHandler.stringToBoolean(ele.getAttribute("CanViewStatus")));
        }
        if (ele.getAttributeNode("CanViewHistory") != null) {
            step.setCanViewHistory(VWXMLHandler.stringToBoolean(ele.getAttribute("CanViewHistory")));
        }
        if (ele.getAttributeNode("IgnoreInvalidUsers") != null) {
            step.setIgnoreInvalidUsers(VWXMLHandler.stringToBoolean(ele.getAttribute("IgnoreInvalidUsers")));
        }
        if (ele.getAttributeNode("Documentation") != null) {
            step.setDocumentation(ele.getAttribute("Documentation"));
        }
        if (ele.getAttributeNode("fn:AuthorTool") != null) {
            step.setAuthorTool(ele.getAttribute("fn:AuthorTool"));
        }
        if ((childNodes = ele.getChildNodes()) != null && (numChilds = childNodes.getLength()) != 0) {
            VWArrayHandler responseHandler = new VWArrayHandler(1, 1);
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (nodeName.equals("Response")) {
                    step.setResponses((String[])responseHandler.addElementToArray(step.getResponses(), ((Element)childNode).getAttribute("Val")));
                    continue;
                }
                if (nodeName.equals("ModelAttributes")) {
                    Hashtable attributes = VWXML_CUR_parser.parseXMLModelAttributes(childNode);
                    step.setAttributes(attributes);
                    continue;
                }
                if (nodeName.equals("StepOperation")) {
                    VWXML_CUR_parser.parseXMLStepOperation(childNode, step);
                    continue;
                }
                if (nodeName.equals("PreRule")) {
                    VWXML_CUR_parser.parseXMLStepRulesList(childNode, step, 0);
                    continue;
                }
                if (nodeName.equals("UpdateRule")) {
                    VWXML_CUR_parser.parseXMLStepRulesList(childNode, step, 1);
                    continue;
                }
                if (!nodeName.equals("PostRule")) continue;
                VWXML_CUR_parser.parseXMLStepRulesList(childNode, step, 2);
            }
        }
    }

    static void parseXPDLfnCompoundStep(Node aNode, VWCompoundStepDefinition step, XPDLInfo xpdlInfo) throws VWException, SAXException {
        int numChilds;
        NodeList childNodes;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        if (ele.getAttributeNode("Documentation") != null) {
            step.setDocumentation(ele.getAttribute("Documentation"));
        }
        if (ele.getAttributeNode("fn:AuthorTool") != null) {
            step.setAuthorTool(ele.getAttribute("fn:AuthorTool"));
        }
        if ((childNodes = ele.getChildNodes()) != null && (numChilds = childNodes.getLength()) != 0) {
            String instructionIdPrefix = VWXMLHandler.toXMLString(step.getMap().getWorkflow().getName() + "-" + step.getMap().getName()) + "-step-" + step.getStepId() + "-Instruction-";
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (nodeName.equals("ModelAttributes") || nodeName.equals("fn:ModelAttributes")) {
                    Hashtable attributes = VWXML_CUR_parser.parseXMLModelAttributes(childNode);
                    step.setAttributes(attributes);
                    continue;
                }
                if (nodeName.equals("PreRule") || nodeName.equals("fn:PreRule")) {
                    VWXML_CUR_parser.parseXMLStepRulesList(childNode, step, 0);
                    continue;
                }
                if (nodeName.equals("PostRule") || nodeName.equals("fn:PostRule")) {
                    VWXML_CUR_parser.parseXMLStepRulesList(childNode, step, 2);
                    continue;
                }
                if (nodeName.equals("Instruction") || nodeName.equals("fn:Instruction")) {
                    VWXPDL_20_parser.makeUniqueInstructionId(childNode, instructionIdPrefix, xpdlInfo);
                    VWXML_CUR_parser.parseXMLSimpleInstructionDefinition(childNode, step);
                    continue;
                }
                if (nodeName.equals("RBInstruction") || nodeName.equals("fn:RBInstruction")) {
                    VWXPDL_20_parser.makeUniqueInstructionId(childNode, instructionIdPrefix, xpdlInfo);
                    VWXML_CUR_parser.parseXMLRBInstructionDefinition(childNode, step);
                    continue;
                }
                if (nodeName.equals("WFEInstruction") || nodeName.equals("fn:WFEInstruction")) {
                    VWXPDL_20_parser.makeUniqueInstructionId(childNode, instructionIdPrefix, xpdlInfo);
                    VWXML_CUR_parser.parseXMLWFEInstructionDefinition(childNode, step);
                    continue;
                }
                if (nodeName.equals("invoke") || nodeName.equals("fn:invoke")) {
                    VWXPDL_20_parser.makeUniqueInstructionId(childNode, instructionIdPrefix, xpdlInfo);
                    VWXML_CUR_parser.parseXMLInvokeInstructionDefinition(childNode, step);
                    continue;
                }
                if (nodeName.equals("receive") || nodeName.equals("fn:receive")) {
                    VWXPDL_20_parser.makeUniqueInstructionId(childNode, instructionIdPrefix, xpdlInfo);
                    VWXML_CUR_parser.parseXMLReceiveInstructionDefinition(childNode, step);
                    continue;
                }
                if (!nodeName.equals("reply") && !nodeName.equals("fn:reply")) continue;
                VWXPDL_20_parser.makeUniqueInstructionId(childNode, instructionIdPrefix, xpdlInfo);
                VWXML_CUR_parser.parseXMLReplyInstructionDefinition(childNode, step);
            }
        }
    }

    static void makeUniqueInstructionId(Node aNode, String instructionIdPrefix, XPDLInfo xpdlInfo) throws VWException {
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        if (ele.getAttributeNode("Id") != null) {
            String idStr = ele.getAttribute("Id");
            ele.setAttribute("Id", Integer.toString(VWXPDL_20_parser.createNewId(instructionIdPrefix + idStr, 3, null, xpdlInfo)));
        }
    }

    static void parseXPDLAssignments(Node aNode, VWMapNode step, String assignTimeSelector, XPDLInfo xpdlInfo) throws VWException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            String[][] assignPairs = new String[0][0];
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(m_namespacePrefix + "Assignment")) continue;
                assignPairs = VWXPDL_20_parser.parseXPDLAssignment(childNode, assignTimeSelector, assignPairs);
            }
            if (assignPairs.length > 0) {
                if (step instanceof VWCompoundStepDefinition) {
                    VWInstructionDefinition instruction = ((VWCompoundStepDefinition)step).createAssignInstruction(assignPairs);
                    String idStr = step.getMap().getWorkflow().getName() + "-" + step.getMap().getName() + "-Step-" + step.getStepId() + "-" + assignTimeSelector + "AssignInstruction";
                    instruction.setInstructionId(VWXPDL_20_parser.createNewId(idStr, 3, step.getMap(), xpdlInfo));
                } else if (assignTimeSelector.equals("Start")) {
                    ((VWStepDefinition)step).setPreAssignments(assignPairs);
                } else {
                    ((VWStepDefinition)step).setPostAssignments(assignPairs);
                }
            }
        }
    }

    static String[][] parseXPDLAssignment(Node aNode, String assignTimeSelector, String[][] oldAssignPairs) throws VWException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return oldAssignPairs;
        }
        Element ele = (Element)aNode;
        String assignTime = ele.getAttribute("AssignTime");
        if (assignTime == null || assignTime.length() == 0) {
            assignTime = "Start";
        }
        if (!assignTime.equals(assignTimeSelector)) {
            return oldAssignPairs;
        }
        String[][] assignPairs = oldAssignPairs;
        String target = null;
        String expression = null;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (nodeName.equals(m_namespacePrefix + "Target")) {
                    target = VWXMLHandler.getXMLString(childNode);
                    continue;
                }
                if (!nodeName.equals(m_namespacePrefix + "Expression")) continue;
                expression = VWXMLHandler.getXMLString(childNode);
            }
        }
        if (target != null && target.length() > 0 && expression != null && expression.length() > 0) {
            int row = oldAssignPairs.length;
            assignPairs = new String[row + 1][2];
            for (int i = 0; i < row; ++i) {
                assignPairs[i] = oldAssignPairs[i];
            }
            assignPairs[row][0] = target;
            assignPairs[row][1] = expression;
        }
        return assignPairs;
    }

    static void parseXPDLTransitions(Node aNode, VWMapDefinition map, XPDLInfo xpdlInfo) throws VWException, SAXException {
        int numChilds;
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null && (numChilds = childNodes.getLength()) != 0) {
            for (int i = 0; i < numChilds; ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (!nodeName.equals(m_namespacePrefix + "Transition")) continue;
                VWXPDL_20_parser.parseXPDLTransition(childNode, map, xpdlInfo);
            }
        }
    }

    static void parseXPDLTransition(Node aNode, VWMapDefinition map, XPDLInfo xpdlInfo) throws VWException, SAXException {
        if (aNode.getNodeType() != 1) {
            return;
        }
        Element ele = (Element)aNode;
        String idStr = ele.getAttribute("Id");
        String nameStr = null;
        if (ele.getAttributeNode("Name") != null) {
            nameStr = ele.getAttribute("Name");
        }
        String fromIdStr = ele.getAttribute("From");
        String toIdStr = ele.getAttribute("To");
        String condition = null;
        String description = null;
        Node connectorGraphicsInfosNode = null;
        Hashtable attributes = null;
        NodeList childNodes = ele.getChildNodes();
        if (childNodes != null) {
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                String nodeName = childNode.getNodeName();
                if (nodeName.equals(m_namespacePrefix + "Condition")) {
                    Element conditionElement = (Element)childNode;
                    if (!conditionElement.getAttribute("Type").equals("CONDITION") || (condition = VWXMLHandler.getXMLString(childNode)) == null) continue;
                    condition = condition.replaceAll("==", "=");
                    continue;
                }
                if (nodeName.equals(m_namespacePrefix + "Description")) {
                    description = VWXMLHandler.getXMLString(childNode);
                    continue;
                }
                if (nodeName.equals(m_namespacePrefix + "ConnectorGraphicsInfos")) {
                    connectorGraphicsInfosNode = childNode;
                    continue;
                }
                if (!nodeName.equals("fn:Route")) continue;
                NodeList grandchildNodes = childNode.getChildNodes();
                for (int nIndex = 0; nIndex < grandchildNodes.getLength(); ++nIndex) {
                    Node grandchildNode = grandchildNodes.item(nIndex);
                    String childNodeName = grandchildNode.getNodeName();
                    if (!childNodeName.equals("ModelAttributes")) continue;
                    attributes = VWXML_CUR_parser.parseXMLModelAttributes(grandchildNode);
                }
            }
        }
        if (fromIdStr != null && toIdStr != null) {
            int fromId = VWXPDL_20_parser.getNewId(fromIdStr, 1, map, xpdlInfo);
            int toId = VWXPDL_20_parser.getNewId(toIdStr, 1, map, xpdlInfo);
            if (fromId >= 0 && toId > 0) {
                VWMapNode mapNode = map.getStep(fromId);
                if (mapNode != null) {
                    int routeId = VWXPDL_20_parser.createNewId(idStr, 2, map, xpdlInfo);
                    VWRouteDefinition route = null;
                    if (fromId != toId) {
                        try {
                            route = mapNode.createRoute(routeId, toId, condition, nameStr);
                        }
                        catch (VWException ex) {
                            VWString msg = new VWString("vw.VWXMLHandler.DuplicateXPDLTranstion", "Skipping duplicate Transition {0} - from ID ({1}) to ID ({2}).", idStr, fromIdStr, toIdStr);
                            System.out.println(msg);
                        }
                    } else {
                        map.updateNextStepId();
                        VWStepDefinition newStep = map.createStep(null);
                        VWString desc = new VWString("vw.api.parseXPDLTransition", "Created during XPDL parsing to prevent a route from a step to itself");
                        newStep.setDescription(desc.toString());
                        route = mapNode.createRoute(routeId, newStep.stepId, condition, nameStr);
                        routeId = VWXPDL_20_parser.createNewId(idStr + ".1", 2, map, xpdlInfo);
                        newStep.createRoute(routeId, toId, null, null);
                    }
                    if (route != null) {
                        if (ele.getAttributeNode("fn:Release") != null) {
                            route.setRelease(VWXMLHandler.stringToBoolean(ele.getAttribute("fn:Release")));
                        }
                        route.setOriginalConnectorGraphicsInfosNode(connectorGraphicsInfosNode);
                        route.setDescription(description);
                        route.setAttributes(attributes);
                    }
                }
            } else {
                VWString msg = new VWString("vw.VWXMLHandler.VWInvalidXPDLTransition", "The XPDL transition {0} does not specify a valid From ID ({1}) or To ID ({2}).", idStr, fromIdStr, toIdStr);
                System.out.println(msg);
            }
        }
    }

    static class XPDLInfo {
        int[] startActivityIds;
        int startNameActivityId;
        int defaultStartActivityId;
        String defaultStartActivitySetId;
        String mainMapActivitySetId;
        IDInfo[] idInfo;
        Node packageDataFields;
        NodeList workflowProcessNodes;
        NodeList partnerLinkTypeNodes;
        NodeList activitySetNodes;
        NodeList partnerLinkNodes;

        XPDLInfo() {
        }
    }

    static class IDInfo {
        String idStr;
        VWMapDefinition map;
        int objectType;
        boolean isStartStep;
        int nNewId;

        IDInfo() {
        }
    }

    static class NodeGraphicsInfo {
        Point point;
        Color color;
        Dimension dimension;
        boolean minimized;

        NodeGraphicsInfo() {
        }
    }
}

